/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemoveDistinctAggregateRule
extends RelOptRule {
    public static final RemoveDistinctAggregateRule INSTANCE = new RemoveDistinctAggregateRule();

    private RemoveDistinctAggregateRule() {
        super(RemoveDistinctAggregateRule.operand(AggregateRel.class, RemoveDistinctAggregateRule.any()));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        AggregateRel aggregate = (AggregateRel)call.rel(0);
        if (!aggregate.containsDistinctCall()) {
            return;
        }
        int nonDistinctCount = 0;
        LinkedHashSet argListSets = new LinkedHashSet();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (!aggCall.isDistinct()) {
                ++nonDistinctCount;
                continue;
            }
            ArrayList<Integer> argList = new ArrayList<Integer>();
            for (Integer arg : aggCall.getArgList()) {
                argList.add(arg);
            }
            argListSets.add(argList);
        }
        Util.permAssert(argListSets.size() > 0, "containsDistinctCall lied");
        if (nonDistinctCount == 0 && argListSets.size() == 1) {
            RelNode converted = this.convertMonopole(aggregate, (List)argListSets.iterator().next());
            call.transformTo(converted);
            return;
        }
        List<RelDataTypeField> aggFields = aggregate.getRowType().getFieldList();
        ArrayList<RexNode> refs = new ArrayList<RexNode>();
        List<String> fieldNames = aggregate.getRowType().getFieldNames();
        BitSet groupSet = aggregate.getGroupSet();
        for (int i : BitSets.toIter(groupSet)) {
            refs.add(RexInputRef.of(i, aggFields));
        }
        ArrayList<AggregateCall> newAggCallList = new ArrayList<AggregateCall>();
        int groupCount = groupSet.cardinality();
        int i = -1;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            ++i;
            if (aggCall.isDistinct()) {
                refs.add(null);
                continue;
            }
            refs.add(new RexInputRef(groupCount + newAggCallList.size(), aggFields.get(groupCount + i).getType()));
            newAggCallList.add(aggCall);
        }
        RelNode rel = newAggCallList.isEmpty() ? null : new AggregateRel(aggregate.getCluster(), aggregate.getChild(), groupSet, newAggCallList);
        for (List list : argListSets) {
            rel = this.doRewrite(aggregate, rel, list, refs);
        }
        rel = CalcRel.createProject(rel, refs, fieldNames);
        call.transformTo(rel);
    }

    private RelNode convertMonopole(AggregateRel aggregate, List<Integer> argList) {
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        AggregateRel distinct = RemoveDistinctAggregateRule.createSelectDistinct(aggregate, argList, sourceOf);
        ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>(aggregate.getAggCallList());
        RemoveDistinctAggregateRule.rewriteAggCalls(newAggCalls, argList, sourceOf);
        AggregateRel newAggregate = new AggregateRel(aggregate.getCluster(), distinct, aggregate.getGroupSet(), newAggCalls);
        return newAggregate;
    }

    private RelNode doRewrite(AggregateRel aggregate, RelNode left, List<Integer> argList, List<RexInputRef> refs) {
        RexBuilder rexBuilder = aggregate.getCluster().getRexBuilder();
        List<RelDataTypeField> leftFields = left == null ? null : left.getRowType().getFieldList();
        HashMap<Integer, Integer> sourceOf = new HashMap<Integer, Integer>();
        AggregateRel distinct = RemoveDistinctAggregateRule.createSelectDistinct(aggregate, argList, sourceOf);
        ArrayList<AggregateCall> aggCallList = new ArrayList<AggregateCall>();
        List<AggregateCall> aggCalls = aggregate.getAggCallList();
        int groupCount = aggregate.getGroupSet().cardinality();
        int i = groupCount - 1;
        for (AggregateCall aggCall : aggCalls) {
            ++i;
            if (!aggCall.isDistinct() || !aggCall.getArgList().equals(argList)) continue;
            int argCount = aggCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j = 0; j < argCount; ++j) {
                Integer arg = aggCall.getArgList().get(j);
                newArgs.add((Integer)sourceOf.get(arg));
            }
            AggregateCall newAggCall = new AggregateCall(aggCall.getAggregation(), false, newArgs, aggCall.getType(), aggCall.getName());
            assert (refs.get(i) == null);
            if (left == null) {
                refs.set(i, new RexInputRef(groupCount + aggCallList.size(), newAggCall.getType()));
            } else {
                refs.set(i, new RexInputRef(leftFields.size() + groupCount + aggCallList.size(), newAggCall.getType()));
            }
            aggCallList.add(newAggCall);
        }
        AggregateRel distinctAgg = new AggregateRel(aggregate.getCluster(), distinct, aggregate.getGroupSet(), aggCallList);
        if (left == null) {
            return distinctAgg;
        }
        List<RelDataTypeField> distinctFields = distinctAgg.getRowType().getFieldList();
        RexNode condition = rexBuilder.makeLiteral(true);
        for (i = 0; i < groupCount; ++i) {
            int leftOrdinal = i;
            int rightOrdinal = (Integer)sourceOf.get(i);
            RexNode equi = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, RexInputRef.of(leftOrdinal, leftFields), new RexInputRef(leftFields.size() + rightOrdinal, distinctFields.get(rightOrdinal).getType()));
            condition = i == 0 ? equi : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, equi);
        }
        return new JoinRel(aggregate.getCluster(), left, distinctAgg, condition, JoinRelType.INNER, (Set<String>)ImmutableSet.of());
    }

    private static void rewriteAggCalls(List<AggregateCall> newAggCalls, List<Integer> argList, Map<Integer, Integer> sourceOf) {
        for (int i = 0; i < newAggCalls.size(); ++i) {
            AggregateCall aggCall = newAggCalls.get(i);
            if (!aggCall.isDistinct() || !aggCall.getArgList().equals(argList)) continue;
            int argCount = aggCall.getArgList().size();
            ArrayList<Integer> newArgs = new ArrayList<Integer>(argCount);
            for (int j = 0; j < argCount; ++j) {
                Integer arg = aggCall.getArgList().get(j);
                newArgs.add(sourceOf.get(arg));
            }
            AggregateCall newAggCall = new AggregateCall(aggCall.getAggregation(), false, newArgs, aggCall.getType(), aggCall.getName());
            newAggCalls.set(i, newAggCall);
        }
    }

    private static AggregateRel createSelectDistinct(AggregateRel aggregate, List<Integer> argList, Map<Integer, Integer> sourceOf) {
        ArrayList<Pair<RexNode, String>> projects = new ArrayList<Pair<RexNode, String>>();
        RelNode child = aggregate.getChild();
        List<RelDataTypeField> childFields = child.getRowType().getFieldList();
        for (int i : BitSets.toIter(aggregate.getGroupSet())) {
            sourceOf.put(i, projects.size());
            projects.add(RexInputRef.of2(i, childFields));
        }
        for (Integer arg : argList) {
            if (sourceOf.get(arg) != null) continue;
            sourceOf.put(arg, projects.size());
            projects.add(RexInputRef.of2(arg, childFields));
        }
        RelNode project = CalcRel.createProject(child, projects, false);
        AggregateRel distinct = new AggregateRel(aggregate.getCluster(), project, BitSets.range(projects.size()), (List<AggregateCall>)ImmutableList.of());
        return distinct;
    }
}

