/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexLiteral;

public abstract class RemoveEmptyRules {
    public static final RelOptRule UNION_INSTANCE = new RelOptRule(RelOptRule.operand(UnionRel.class, RelOptRule.unordered(RelOptRule.operand(EmptyRel.class, RelOptRule.none()), new RelOptRuleOperand[0])), "Union"){

        public void onMatch(RelOptRuleCall call) {
            RelNode newRel;
            UnionRel union = (UnionRel)call.rel(0);
            List<RelNode> childRels = call.getChildRels(union);
            ArrayList<RelNode> newChildRels = new ArrayList<RelNode>();
            for (RelNode childRel : childRels) {
                if (childRel instanceof EmptyRel) continue;
                newChildRels.add(childRel);
            }
            assert (newChildRels.size() < childRels.size()) : "planner promised us at least one EmptyRel child";
            switch (newChildRels.size()) {
                case 0: {
                    newRel = RemoveEmptyRules.empty(union);
                    break;
                }
                case 1: {
                    newRel = RelOptUtil.createCastRel((RelNode)newChildRels.get(0), union.getRowType(), true);
                    break;
                }
                default: {
                    newRel = new UnionRel(union.getCluster(), newChildRels, union.all);
                }
            }
            call.transformTo(newRel);
        }
    };
    public static final RelOptRule PROJECT_INSTANCE = new RemoveEmptySingleRule(ProjectRelBase.class, "PruneEmptyProject");
    public static final RelOptRule FILTER_INSTANCE = new RemoveEmptySingleRule(FilterRelBase.class, "PruneEmptyFilter");
    public static final RelOptRule SORT_INSTANCE = new RemoveEmptySingleRule(SortRel.class, "PruneEmptySort");
    public static final RelOptRule SORT_FETCH_ZERO_INSTANCE = new RelOptRule(RelOptRule.operand(SortRel.class, RelOptRule.any()), "PruneSortLimit0"){

        public void onMatch(RelOptRuleCall call) {
            SortRel sort = (SortRel)call.rel(0);
            if (sort.fetch != null && RexLiteral.intValue(sort.fetch) == 0) {
                call.transformTo(RemoveEmptyRules.empty(sort));
            }
        }
    };
    public static final RelOptRule AGGREGATE_INSTANCE = new RemoveEmptySingleRule(AggregateRelBase.class, "PruneEmptyAggregate");
    public static final RelOptRule JOIN_LEFT_INSTANCE = new RelOptRule(RelOptRule.operand(JoinRelBase.class, RelOptRule.some(RelOptRule.operand(EmptyRel.class, RelOptRule.none()), RelOptRule.operand(RelNode.class, RelOptRule.any()))), "PruneEmptyJoin(left)"){

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            if (join.getJoinType().generatesNullsOnLeft()) {
                return;
            }
            call.transformTo(RemoveEmptyRules.empty(join));
        }
    };
    public static final RelOptRule JOIN_RIGHT_INSTANCE = new RelOptRule(RelOptRule.operand(JoinRelBase.class, RelOptRule.some(RelOptRule.operand(RelNode.class, RelOptRule.any()), RelOptRule.operand(EmptyRel.class, RelOptRule.none()))), "PruneEmptyJoin(right)"){

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            if (join.getJoinType().generatesNullsOnRight()) {
                return;
            }
            call.transformTo(RemoveEmptyRules.empty(join));
        }
    };

    private static EmptyRel empty(RelNode node) {
        return new EmptyRel(node.getCluster(), node.getRowType());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RemoveEmptySingleRule
    extends RelOptRule {
        public RemoveEmptySingleRule(Class<? extends SingleRel> clazz, String description) {
            super(RemoveEmptySingleRule.operand(clazz, RemoveEmptySingleRule.operand(EmptyRel.class, RemoveEmptySingleRule.none()), new RelOptRuleOperand[0]), description);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            SingleRel single = (SingleRel)call.rel(0);
            call.transformTo(RemoveEmptyRules.empty(single));
        }
    }
}

