/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.WeakHashMap;
import net.hydromatic.optiq.util.graph.DefaultDirectedGraph;
import net.hydromatic.optiq.util.graph.DefaultEdge;
import net.hydromatic.optiq.util.graph.DirectedGraph;
import net.hydromatic.optiq.util.graph.Graphs;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConventionTraitDef
extends RelTraitDef<Convention> {
    public static final ConventionTraitDef INSTANCE = new ConventionTraitDef();
    private final WeakHashMap<RelOptPlanner, ConversionData> plannerConversionMap = new WeakHashMap();

    private ConventionTraitDef() {
    }

    @Override
    public Class<Convention> getTraitClass() {
        return Convention.class;
    }

    @Override
    public String getSimpleName() {
        return "convention";
    }

    @Override
    public Convention getDefault() {
        return Convention.NONE;
    }

    @Override
    public void registerConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
        if (converterRule.isGuaranteed()) {
            ConversionData conversionData = this.getConversionData(planner);
            Convention inConvention = (Convention)converterRule.getInTrait();
            Convention outConvention = (Convention)converterRule.getOutTrait();
            conversionData.conversionGraph.addVertex(inConvention);
            conversionData.conversionGraph.addVertex(outConvention);
            conversionData.conversionGraph.addEdge(inConvention, outConvention);
            conversionData.mapArcToConverterRule.put(Pair.of(inConvention, outConvention), (Object)converterRule);
        }
    }

    @Override
    public void deregisterConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
        if (converterRule.isGuaranteed()) {
            ConversionData conversionData = this.getConversionData(planner);
            Convention inConvention = (Convention)converterRule.getInTrait();
            Convention outConvention = (Convention)converterRule.getOutTrait();
            boolean removed = conversionData.conversionGraph.removeEdge(inConvention, outConvention);
            assert (removed);
            conversionData.mapArcToConverterRule.remove(Pair.of(inConvention, outConvention), (Object)converterRule);
        }
    }

    @Override
    public RelNode convert(RelOptPlanner planner, RelNode rel, Convention toConvention, boolean allowInfiniteCostConverters) {
        ConversionData conversionData = this.getConversionData(planner);
        Convention fromConvention = rel.getConvention();
        List<List<Convention>> conversionPaths = conversionData.getPaths(fromConvention, toConvention);
        block0: for (List<Convention> conversionPath : conversionPaths) {
            assert (conversionPath.get(0) == fromConvention);
            assert (conversionPath.get(conversionPath.size() - 1) == toConvention);
            RelNode converted = rel;
            Convention previous = null;
            for (Convention arc : conversionPath) {
                if (planner.getCost(converted).isInfinite() && !allowInfiniteCostConverters) continue block0;
                if (previous != null && (converted = this.changeConvention(converted, previous, arc, conversionData.mapArcToConverterRule)) == null) {
                    throw Util.newInternal("Converter from " + previous + " to " + arc + " guaranteed that it could convert any relexp");
                }
                previous = arc;
            }
            return converted;
        }
        return null;
    }

    private RelNode changeConvention(RelNode rel, Convention source, Convention target, Multimap<Pair<Convention, Convention>, ConverterRule> mapArcToConverterRule) {
        assert (source == rel.getConvention());
        Pair<Convention, Convention> key = Pair.of(source, target);
        for (ConverterRule rule : mapArcToConverterRule.get(key)) {
            assert (rule.getInTrait() == source);
            assert (rule.getOutTrait() == target);
            RelNode converted = rule.convert(rel);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }

    @Override
    public boolean canConvert(RelOptPlanner planner, Convention fromConvention, Convention toConvention) {
        ConversionData conversionData = this.getConversionData(planner);
        return conversionData.getShortestPath(fromConvention, toConvention) != null;
    }

    private ConversionData getConversionData(RelOptPlanner planner) {
        ConversionData conversionData = this.plannerConversionMap.get(planner);
        if (conversionData == null) {
            conversionData = new ConversionData();
            this.plannerConversionMap.put(planner, conversionData);
        }
        return conversionData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConversionData {
        final DirectedGraph<Convention, DefaultEdge> conversionGraph = DefaultDirectedGraph.create();
        final Multimap<Pair<Convention, Convention>, ConverterRule> mapArcToConverterRule = HashMultimap.create();
        private Graphs.FrozenGraph<Convention, DefaultEdge> pathMap;

        private ConversionData() {
        }

        public List<List<Convention>> getPaths(Convention fromConvention, Convention toConvention) {
            return this.getPathMap().getPaths(fromConvention, toConvention);
        }

        private Graphs.FrozenGraph<Convention, DefaultEdge> getPathMap() {
            if (this.pathMap == null) {
                this.pathMap = Graphs.makeImmutable(this.conversionGraph);
            }
            return this.pathMap;
        }

        public List<Convention> getShortestPath(Convention fromConvention, Convention toConvention) {
            return this.getPathMap().getShortestPath(fromConvention, toConvention);
        }
    }
}

