/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class OrderedBytesBase<T>
implements DataType<T> {
    protected final Order order;

    protected OrderedBytesBase(Order order) {
        this.order = order;
    }

    @Override
    public boolean isOrderPreserving() {
        return true;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public boolean isNullable() {
        return true;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int skip(PositionedByteRange src) {
        return OrderedBytes.skip(src);
    }
}

