/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBigDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;

public final class LazyPrimitiveObjectInspectorFactory {
    public static final LazyBooleanObjectInspector LAZY_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyBooleanObjectInspector LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyByteObjectInspector LAZY_BYTE_OBJECT_INSPECTOR;
    public static final LazyShortObjectInspector LAZY_SHORT_OBJECT_INSPECTOR;
    public static final LazyIntObjectInspector LAZY_INT_OBJECT_INSPECTOR;
    public static final LazyLongObjectInspector LAZY_LONG_OBJECT_INSPECTOR;
    public static final LazyFloatObjectInspector LAZY_FLOAT_OBJECT_INSPECTOR;
    public static final LazyDoubleObjectInspector LAZY_DOUBLE_OBJECT_INSPECTOR;
    public static final LazyVoidObjectInspector LAZY_VOID_OBJECT_INSPECTOR;
    public static final LazyTimestampObjectInspector LAZY_TIMESTAMP_OBJECT_INSPECTOR;
    public static final LazyBinaryObjectInspector LAZY_BINARY_OBJECT_INSPECTOR;
    public static final LazyBigDecimalObjectInspector LAZY_BIG_DECIMAL_OBJECT_INSPECTOR;
    static HashMap<ArrayList<Object>, LazyStringObjectInspector> cachedLazyStringObjectInspector;

    public static LazyStringObjectInspector getLazyStringObjectInspector(boolean escaped, byte escapeChar) {
        ArrayList<Comparable<Boolean>> signature = new ArrayList<Comparable<Boolean>>();
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyStringObjectInspector result = cachedLazyStringObjectInspector.get(signature);
        if (result == null) {
            result = new LazyStringObjectInspector(escaped, escapeChar);
            cachedLazyStringObjectInspector.put(signature, result);
        }
        return result;
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeInfo typeInfo, boolean escaped, byte escapeChar) {
        return LazyPrimitiveObjectInspectorFactory.getLazyObjectInspector(typeInfo, escaped, escapeChar, false);
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveTypeInfo typeInfo, boolean escaped, byte escapeChar, boolean extBoolean) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = typeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case BYTE: {
                return LAZY_BYTE_OBJECT_INSPECTOR;
            }
            case SHORT: {
                return LAZY_SHORT_OBJECT_INSPECTOR;
            }
            case INT: {
                return LAZY_INT_OBJECT_INSPECTOR;
            }
            case LONG: {
                return LAZY_LONG_OBJECT_INSPECTOR;
            }
            case FLOAT: {
                return LAZY_FLOAT_OBJECT_INSPECTOR;
            }
            case DOUBLE: {
                return LAZY_DOUBLE_OBJECT_INSPECTOR;
            }
            case STRING: {
                return LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector(escaped, escapeChar);
            }
            case BINARY: {
                return LAZY_BINARY_OBJECT_INSPECTOR;
            }
            case VOID: {
                return LAZY_VOID_OBJECT_INSPECTOR;
            }
            case TIMESTAMP: {
                return LAZY_TIMESTAMP_OBJECT_INSPECTOR;
            }
            case DECIMAL: {
                return LAZY_BIG_DECIMAL_OBJECT_INSPECTOR;
            }
            case BOOLEAN: {
                return LazyPrimitiveObjectInspectorFactory.getLazyBooleanObjectInspector(extBoolean);
            }
        }
        throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
    }

    private LazyPrimitiveObjectInspectorFactory() {
    }

    private static LazyBooleanObjectInspector getLazyBooleanObjectInspector(boolean extLiteral) {
        return extLiteral ? LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR : LAZY_BOOLEAN_OBJECT_INSPECTOR;
    }

    static {
        LAZY_EXT_BOOLEAN_OBJECT_INSPECTOR.setExtendedLiteral(true);
        LAZY_BYTE_OBJECT_INSPECTOR = new LazyByteObjectInspector();
        LAZY_SHORT_OBJECT_INSPECTOR = new LazyShortObjectInspector();
        LAZY_INT_OBJECT_INSPECTOR = new LazyIntObjectInspector();
        LAZY_LONG_OBJECT_INSPECTOR = new LazyLongObjectInspector();
        LAZY_FLOAT_OBJECT_INSPECTOR = new LazyFloatObjectInspector();
        LAZY_DOUBLE_OBJECT_INSPECTOR = new LazyDoubleObjectInspector();
        LAZY_VOID_OBJECT_INSPECTOR = new LazyVoidObjectInspector();
        LAZY_TIMESTAMP_OBJECT_INSPECTOR = new LazyTimestampObjectInspector();
        LAZY_BINARY_OBJECT_INSPECTOR = new LazyBinaryObjectInspector();
        LAZY_BIG_DECIMAL_OBJECT_INSPECTOR = new LazyBigDecimalObjectInspector();
        cachedLazyStringObjectInspector = new HashMap();
    }
}

