/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.config;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class OServerConfigurationLoaderXml {
    private Class<? extends OServerConfiguration> rootClass;
    private JAXBContext context;
    private InputStream inputStream;
    private File file;

    public OServerConfigurationLoaderXml(Class<? extends OServerConfiguration> iRootClass, InputStream iInputStream) {
        this.rootClass = iRootClass;
        this.inputStream = iInputStream;
    }

    public OServerConfigurationLoaderXml(Class<? extends OServerConfiguration> iRootClass, File iFile) {
        this.rootClass = iRootClass;
        this.file = iFile;
    }

    public OServerConfiguration load() throws IOException {
        try {
            OServerConfiguration obj;
            if (this.file != null) {
                String current;
                String path = OFileUtils.getPath((String)this.file.getAbsolutePath());
                if (path.startsWith(current = OFileUtils.getPath((String)new File("").getAbsolutePath()))) {
                    path = path.substring(current.length() + 1);
                }
                OLogManager.instance().info((Object)this, "Loading configuration from: %s...", new Object[]{path});
            } else {
                OLogManager.instance().info((Object)this, "Loading configuration from input stream", new Object[0]);
            }
            this.context = JAXBContext.newInstance((Class[])new Class[]{this.rootClass});
            Unmarshaller unmarshaller = this.context.createUnmarshaller();
            unmarshaller.setSchema(null);
            if (this.file != null) {
                if (!this.file.exists()) {
                    return this.rootClass.getConstructor(OServerConfigurationLoaderXml.class).newInstance(this);
                }
                obj = this.rootClass.cast(unmarshaller.unmarshal(this.file));
                obj.location = this.file.getAbsolutePath();
            } else {
                obj = this.rootClass.cast(unmarshaller.unmarshal(this.inputStream));
                obj.location = "memory";
            }
            if (obj.properties != null) {
                for (OServerEntryConfiguration prop : obj.properties) {
                    try {
                        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)prop.name);
                        if (config == null) continue;
                        config.setValue((Object)prop.value);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return obj;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Invalid syntax. Below an example of how it should be:", (Throwable)e, new Object[0]);
            try {
                this.context = JAXBContext.newInstance((Class[])new Class[]{this.rootClass});
                Marshaller marshaller = this.context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                OServerConfiguration example = this.rootClass.getConstructor(OServerConfigurationLoaderXml.class).newInstance(this);
                marshaller.marshal((Object)example, (OutputStream)System.out);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new IOException(e);
        }
    }

    public void save(OServerConfiguration iRootObject) throws IOException {
        if (this.file != null) {
            try {
                this.context = JAXBContext.newInstance((Class[])new Class[]{this.rootClass});
                Marshaller marshaller = this.context.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                marshaller.marshal((Object)iRootObject, (Writer)new FileWriter(this.file));
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

