/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OStorageSynchronizer;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OAbstractReplicatedTask<T>
extends OAbstractRemoteTask<T> {
    private static final long serialVersionUID = 1L;

    public OAbstractReplicatedTask() {
    }

    public OAbstractReplicatedTask(long iRunId, long iOperationId) {
        super(iRunId, iOperationId);
    }

    public OAbstractReplicatedTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String databaseName, ODistributedServerManager.EXECUTION_MODE iMode) {
        super(iServer, iDistributedSrvMgr, databaseName, iMode);
        this.operationSerial = iDistributedSrvMgr.incrementDistributedSerial(databaseName);
        ODistributedServerLog.debug((Object)this, this.getNodeSource(), this.nodeDestination, ODistributedServerLog.DIRECTION.OUT, "creating operation id %d.%d for db=%s class=%s", this.runId, this.operationSerial, databaseName, this.getClass().getSimpleName());
    }

    public abstract ODatabaseJournal.OPERATION_TYPES getOperationType();

    public abstract String getPayload();

    @Override
    public T call() throws Exception {
        Object localResult = this.getDistributedServerManager().enqueueLocalExecution(this);
        if (this.mode != ODistributedServerManager.EXECUTION_MODE.FIRE_AND_FORGET) {
            return (T)localResult;
        }
        return null;
    }

    @Override
    public void handleConflict(String iRemoteNode, Object localResult, Object remoteResult) {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getNodeSource());
        out.writeUTF(this.nodeDestination);
        out.writeUTF(this.databaseName);
        out.writeLong(this.runId);
        out.writeLong(this.operationSerial);
        out.writeByte(this.mode.ordinal());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setNodeSource(in.readUTF());
        this.nodeDestination = in.readUTF();
        this.serverInstance = OServer.getInstance(this.nodeDestination);
        this.databaseName = in.readUTF();
        this.runId = in.readLong();
        this.operationSerial = in.readLong();
        this.mode = ODistributedServerManager.EXECUTION_MODE.values()[in.readByte()];
    }

    public void setAsCommitted(OStorageSynchronizer dbSynchronizer, long operationLogOffset) throws IOException {
        dbSynchronizer.getLog().setOperationStatus(operationLogOffset, null, ODatabaseJournal.OPERATION_STATUS.COMMITTED);
    }

    public void setAsCanceled(OStorageSynchronizer dbSynchronizer, long operationLogOffset) throws IOException {
        dbSynchronizer.getLog().setOperationStatus(operationLogOffset, null, ODatabaseJournal.OPERATION_STATUS.CANCELED);
    }
}

