/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OAlignResponseTask
extends OAbstractRemoteTask<Integer> {
    private static final long serialVersionUID = 1L;
    protected int aligned;

    public OAlignResponseTask() {
    }

    public OAlignResponseTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, int iAligned) {
        super(iServer, iDistributedSrvMgr, iDbName, iMode);
        this.aligned = iAligned;
    }

    @Override
    public Integer call() throws Exception {
        ODistributedServerManager dManager = this.getDistributedServerManager();
        if (this.aligned == -1) {
            ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "alignment postponed for db '%s'", this.databaseName);
            dManager.postponeAlignment(this.getNodeSource(), this.databaseName);
        } else {
            ODistributedServerLog.info((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "alignment ended against db '%s': %d operation(s)", this.databaseName, this.aligned);
            dManager.endAlignment(this.getNodeSource(), this.databaseName);
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.aligned);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.aligned = in.readInt();
    }

    @Override
    public String getName() {
        return "align_response";
    }
}

