/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OReplicationConflictResolver;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.journal.ODatabaseJournal;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask<ORecordVersion> {
    private static final long serialVersionUID = 1L;
    protected byte[] content;
    protected byte recordType;

    public OUpdateRecordTask() {
    }

    public OUpdateRecordTask(OServer iServer, ODistributedServerManager iDistributedSrvMgr, String iDbName, ODistributedServerManager.EXECUTION_MODE iMode, ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType) {
        super(iServer, iDistributedSrvMgr, iDbName, iMode, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    public OUpdateRecordTask(long iRunId, long iOperationId, ORecordId iRid, byte[] iContent, ORecordVersion iVersion, byte iRecordType) {
        super(iRunId, iOperationId, iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordVersion executeOnLocalNode() {
        ODistributedServerLog.debug((Object)this, this.getDistributedServerManager().getLocalNodeId(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "update record %s/%s v.%s oper=%d.%d", this.databaseName, this.rid.toString(), this.version.toString(), this.runId, this.operationSerial);
        ORecordInternal record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType);
        ODatabaseDocumentTx database = this.openDatabase();
        try {
            if (this.version.getCounter() > -1) {
                this.version.setRollbackMode();
            }
            record.fill((ORID)this.rid, this.version, this.content, true);
            record.save();
            ORecordVersion oRecordVersion = record.getRecordVersion();
            return oRecordVersion;
        }
        finally {
            this.closeDatabase(database);
        }
    }

    @Override
    public void handleConflict(String iRemoteNodeId, Object localResult, Object remoteResult) {
        OReplicationConflictResolver resolver = this.getDatabaseSynchronizer().getConflictResolver();
        resolver.handleUpdateConflict(iRemoteNodeId, this.rid, this.version, (ORecordVersion)remoteResult);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.rid.toString());
        out.writeInt(this.content.length);
        out.write(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().writeTo((DataOutput)out, this.version);
        out.write(this.recordType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rid = new ORecordId(in.readUTF());
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        if (this.version == null) {
            this.version = OVersionFactory.instance().createUntrackedVersion();
        }
        this.version.getSerializer().readFrom((DataInput)in, this.version);
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    public ODatabaseJournal.OPERATION_TYPES getOperationType() {
        return ODatabaseJournal.OPERATION_TYPES.RECORD_UPDATE;
    }
}

