/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.server.config.OServerConfiguration;
import com.orientechnologies.orient.server.config.OServerHookConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import java.lang.reflect.Method;
import java.util.List;

public class OConfigurableHooksManager
implements ODatabaseLifecycleListener {
    private List<OServerHookConfiguration> configuredHooks;

    public OConfigurableHooksManager(OServerConfiguration iCfg) {
        this.configuredHooks = iCfg.hooks;
        if (this.configuredHooks != null && !this.configuredHooks.isEmpty()) {
            Orient.instance().addDbLifecycleListener((ODatabaseLifecycleListener)this);
        }
    }

    public void onOpen(ODatabase iDatabase) {
        if (iDatabase instanceof ODatabaseComplex) {
            ODatabaseComplex db = (ODatabaseComplex)iDatabase;
            for (OServerHookConfiguration hook : this.configuredHooks) {
                try {
                    ORecordHook.HOOK_POSITION pos = ORecordHook.HOOK_POSITION.valueOf((String)hook.position);
                    ORecordHook h = (ORecordHook)Class.forName(hook.clazz).newInstance();
                    if (hook.parameters != null && hook.parameters.length > 0) {
                        try {
                            Method m = h.getClass().getDeclaredMethod("config", OServerParameterConfiguration[].class);
                            m.invoke((Object)h, new Object[]{hook.parameters});
                        }
                        catch (Exception e) {
                            OLogManager.instance().warn((Object)this, "[configure] Failed to configure hook '%s'. Parameters specified but hook don support parameters. Should have a method config with parameters OServerParameterConfiguration[] ", new Object[]{hook.clazz});
                        }
                    }
                    db.registerHook(h, pos);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    OLogManager.instance().error((Object)this, "[configure] Failed to configure hook '%s' due to the an error : ", new Object[]{hook.clazz, e.getMessage()});
                }
            }
        }
    }

    public void onClose(ODatabase iDatabase) {
    }

    public String getName() {
        return "HookRegisters";
    }
}

