/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.schedule;

import com.orientechnologies.orient.server.schedule.OAlwaysTrueValueMatcher;
import com.orientechnologies.orient.server.schedule.ODayOfMonthValueMatcher;
import com.orientechnologies.orient.server.schedule.OIntArrayValueMatcher;
import com.orientechnologies.orient.server.schedule.OInvalidPatternException;
import com.orientechnologies.orient.server.schedule.OValueMatcher;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class OSchedulingPattern {
    private static final ValueParser MINUTE_VALUE_PARSER = new MinuteValueParser();
    private static final ValueParser HOUR_VALUE_PARSER = new HourValueParser();
    private static final ValueParser DAY_OF_MONTH_VALUE_PARSER = new DayOfMonthValueParser();
    private static final ValueParser MONTH_VALUE_PARSER = new MonthValueParser();
    private static final ValueParser DAY_OF_WEEK_VALUE_PARSER = new DayOfWeekValueParser();
    private String asString;
    protected ArrayList minuteMatchers = new ArrayList();
    protected ArrayList hourMatchers = new ArrayList();
    protected ArrayList dayOfMonthMatchers = new ArrayList();
    protected ArrayList monthMatchers = new ArrayList();
    protected ArrayList dayOfWeekMatchers = new ArrayList();
    protected int matcherSize = 0;

    public static boolean validate(String schedulingPattern) {
        try {
            new OSchedulingPattern(schedulingPattern);
        }
        catch (OInvalidPatternException e) {
            return false;
        }
        return true;
    }

    public OSchedulingPattern(String pattern) throws OInvalidPatternException {
        this.asString = pattern;
        StringTokenizer st1 = new StringTokenizer(pattern, "|");
        if (st1.countTokens() < 1) {
            throw new OInvalidPatternException("invalid pattern: \"" + pattern + "\"");
        }
        while (st1.hasMoreTokens()) {
            String localPattern = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(localPattern, " \t");
            if (st2.countTokens() != 5) {
                throw new OInvalidPatternException("invalid pattern: \"" + localPattern + "\"");
            }
            try {
                this.minuteMatchers.add(this.buildValueMatcher(st2.nextToken(), MINUTE_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new OInvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing minutes field: " + e.getMessage() + ".");
            }
            try {
                this.hourMatchers.add(this.buildValueMatcher(st2.nextToken(), HOUR_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new OInvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing hours field: " + e.getMessage() + ".");
            }
            try {
                this.dayOfMonthMatchers.add(this.buildValueMatcher(st2.nextToken(), DAY_OF_MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new OInvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing days of month field: " + e.getMessage() + ".");
            }
            try {
                this.monthMatchers.add(this.buildValueMatcher(st2.nextToken(), MONTH_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new OInvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing months field: " + e.getMessage() + ".");
            }
            try {
                this.dayOfWeekMatchers.add(this.buildValueMatcher(st2.nextToken(), DAY_OF_WEEK_VALUE_PARSER));
            }
            catch (Exception e) {
                throw new OInvalidPatternException("invalid pattern \"" + localPattern + "\". Error parsing days of week field: " + e.getMessage() + ".");
            }
            ++this.matcherSize;
        }
    }

    private OValueMatcher buildValueMatcher(String str, ValueParser parser) throws Exception {
        if (str.length() == 1 && str.equals("*")) {
            return new OAlwaysTrueValueMatcher();
        }
        ArrayList values = new ArrayList();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            ArrayList local;
            String element = st.nextToken();
            try {
                local = this.parseListElement(element, parser);
            }
            catch (Exception e) {
                throw new Exception("invalid field \"" + str + "\", invalid element \"" + element + "\", " + e.getMessage());
            }
            for (Object value : local) {
                if (values.contains(value)) continue;
                values.add(value);
            }
        }
        if (values.size() == 0) {
            throw new Exception("invalid field \"" + str + "\"");
        }
        if (parser == DAY_OF_MONTH_VALUE_PARSER) {
            return new ODayOfMonthValueMatcher(values);
        }
        return new OIntArrayValueMatcher(values);
    }

    private ArrayList parseListElement(String str, ValueParser parser) throws Exception {
        ArrayList values;
        StringTokenizer st = new StringTokenizer(str, "/");
        int size = st.countTokens();
        if (size < 1 || size > 2) {
            throw new Exception("syntax error");
        }
        try {
            values = this.parseRange(st.nextToken(), parser);
        }
        catch (Exception e) {
            throw new Exception("invalid range, " + e.getMessage());
        }
        if (size == 2) {
            int div;
            String dStr = st.nextToken();
            try {
                div = Integer.parseInt(dStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid divisor \"" + dStr + "\"");
            }
            if (div < 1) {
                throw new Exception("non positive divisor \"" + div + "\"");
            }
            ArrayList values2 = new ArrayList();
            for (int i = 0; i < values.size(); i += div) {
                values2.add(values.get(i));
            }
            return values2;
        }
        return values;
    }

    private ArrayList parseRange(String str, ValueParser parser) throws Exception {
        int v2;
        int v1;
        if (str.equals("*")) {
            int min = parser.getMinValue();
            int max = parser.getMaxValue();
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = min; i <= max; ++i) {
                values.add(new Integer(i));
            }
            return values;
        }
        StringTokenizer st = new StringTokenizer(str, "-");
        int size = st.countTokens();
        if (size < 1 || size > 2) {
            throw new Exception("syntax error");
        }
        String v1Str = st.nextToken();
        try {
            v1 = parser.parse(v1Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v1Str + "\", " + e.getMessage());
        }
        if (size == 1) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            values.add(new Integer(v1));
            return values;
        }
        String v2Str = st.nextToken();
        try {
            v2 = parser.parse(v2Str);
        }
        catch (Exception e) {
            throw new Exception("invalid value \"" + v2Str + "\", " + e.getMessage());
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        if (v1 < v2) {
            for (int i = v1; i <= v2; ++i) {
                values.add(new Integer(i));
            }
        } else if (v1 > v2) {
            int i;
            int min = parser.getMinValue();
            int max = parser.getMaxValue();
            for (i = v1; i <= max; ++i) {
                values.add(new Integer(i));
            }
            for (i = min; i <= v2; ++i) {
                values.add(new Integer(i));
            }
        } else {
            values.add(new Integer(v1));
        }
        return values;
    }

    public boolean match(TimeZone timezone, long millis) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(millis);
        gc.setTimeZone(timezone);
        int minute = gc.get(12);
        int hour = gc.get(11);
        int dayOfMonth = gc.get(5);
        int month = gc.get(2) + 1;
        int dayOfWeek = gc.get(7) - 1;
        int year = gc.get(1);
        for (int i = 0; i < this.matcherSize; ++i) {
            boolean eval;
            OValueMatcher minuteMatcher = (OValueMatcher)this.minuteMatchers.get(i);
            OValueMatcher hourMatcher = (OValueMatcher)this.hourMatchers.get(i);
            OValueMatcher dayOfMonthMatcher = (OValueMatcher)this.dayOfMonthMatchers.get(i);
            OValueMatcher monthMatcher = (OValueMatcher)this.monthMatchers.get(i);
            OValueMatcher dayOfWeekMatcher = (OValueMatcher)this.dayOfWeekMatchers.get(i);
            boolean bl = minuteMatcher.match(minute) && hourMatcher.match(hour) && (dayOfMonthMatcher instanceof ODayOfMonthValueMatcher ? ((ODayOfMonthValueMatcher)dayOfMonthMatcher).match(dayOfMonth, month, gc.isLeapYear(year)) : dayOfMonthMatcher.match(dayOfMonth)) && monthMatcher.match(month) && dayOfWeekMatcher.match(dayOfWeek) ? true : (eval = false);
            if (!eval) continue;
            return true;
        }
        return false;
    }

    public boolean match(long millis) {
        return this.match(TimeZone.getDefault(), millis);
    }

    public String toString() {
        return this.asString;
    }

    private static int parseAlias(String value, String[] aliases, int offset) throws Exception {
        for (int i = 0; i < aliases.length; ++i) {
            if (!aliases[i].equalsIgnoreCase(value)) continue;
            return offset + i;
        }
        throw new Exception("invalid alias \"" + value + "\"");
    }

    private static class DayOfWeekValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};

        public DayOfWeekValueParser() {
            super(0, 7);
        }

        @Override
        public int parse(String value) throws Exception {
            try {
                return super.parse(value) % 7;
            }
            catch (Exception e) {
                return OSchedulingPattern.parseAlias(value, DayOfWeekValueParser.ALIASES, 0);
            }
        }
    }

    private static class MonthValueParser
    extends SimpleValueParser {
        private static String[] ALIASES = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};

        public MonthValueParser() {
            super(1, 12);
        }

        @Override
        public int parse(String value) throws Exception {
            try {
                return super.parse(value);
            }
            catch (Exception e) {
                return OSchedulingPattern.parseAlias(value, MonthValueParser.ALIASES, 1);
            }
        }
    }

    private static class DayOfMonthValueParser
    extends SimpleValueParser {
        public DayOfMonthValueParser() {
            super(1, 31);
        }

        @Override
        public int parse(String value) throws Exception {
            if (value.equalsIgnoreCase("L")) {
                return 32;
            }
            return super.parse(value);
        }
    }

    private static class HourValueParser
    extends SimpleValueParser {
        public HourValueParser() {
            super(0, 23);
        }
    }

    private static class MinuteValueParser
    extends SimpleValueParser {
        public MinuteValueParser() {
            super(0, 59);
        }
    }

    private static class SimpleValueParser
    implements ValueParser {
        protected int minValue;
        protected int maxValue;

        public SimpleValueParser(int minValue, int maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public int parse(String value) throws Exception {
            int i;
            try {
                i = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new Exception("invalid integer value");
            }
            if (i < this.minValue || i > this.maxValue) {
                throw new Exception("value out of range");
            }
            return i;
        }

        @Override
        public int getMinValue() {
            return this.minValue;
        }

        @Override
        public int getMaxValue() {
            return this.maxValue;
        }
    }

    private static interface ValueParser {
        public int parse(String var1) throws Exception;

        public int getMinValue();

        public int getMaxValue();
    }
}

