/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.cda;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.cda.CdaQueryEntry;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public abstract class CdaQueryBackend
implements Cloneable {
    public static final String METHOD_LIST_PARAMETERS = "listParameters";
    public static final String DATA_ACCESS_ID = "dataAccessId";
    public static final String METHOD_DO_QUERY = "doQuery";
    public static final String PARAM_NAME = "name";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_DEFAULT_VALUE = "defaultValue";
    public static final String PARAM_PATTERN = "pattern";
    public static final String TYPE_DATE = "Date";
    public static final String TYPE_INTEGER = "Integer";
    public static final String TYPE_NUMERIC = "Numeric";
    public static final String TYPE_STRING = "String";
    public static final String TYPE_ARRAY_SUFFIX = "Array";
    private String username;
    private String password;
    private String solution;
    private String path;
    private String file;
    private boolean sugarMode;
    private transient String baseUrl;
    private DataFactoryContext context;

    public void initialize(DataFactoryContext context) {
        this.context = context;
    }

    protected DataFactoryContext getContext() {
        return this.context;
    }

    protected String parameterToString(String name, String type, String pattern, Object raw) throws ReportDataFactoryException {
        if (raw == null) {
            return "";
        }
        if (TYPE_DATE.equals(type)) {
            if (!(raw instanceof Date) && !(raw instanceof Number)) {
                throw new ReportDataFactoryException("For parameter " + name + " Expected date, but got " + raw.getClass());
            }
            ResourceBundleFactory resourceBundleFactory = this.context.getResourceBundleFactory();
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, resourceBundleFactory.getLocale());
            dateFormat.setTimeZone(resourceBundleFactory.getTimeZone());
            return dateFormat.format(raw);
        }
        if (TYPE_INTEGER.equals(type) || TYPE_NUMERIC.equals(type)) {
            if (!(raw instanceof Number)) {
                throw new ReportDataFactoryException("For parameter " + name + " Expected number, but got " + raw.getClass());
            }
            return String.valueOf(raw);
        }
        if (TYPE_STRING.equals(type)) {
            return String.valueOf(raw);
        }
        if (type.endsWith(TYPE_ARRAY_SUFFIX)) {
            if (!raw.getClass().isArray()) {
                if (raw instanceof String) {
                    return raw.toString();
                }
                throw new ReportDataFactoryException("For parameter " + name + " Expected array, but got " + raw.getClass());
            }
            CSVQuoter quoter = new CSVQuoter(';');
            String arrayType = type.substring(0, type.length() - 5);
            StringBuilder b = new StringBuilder();
            int length = Array.getLength(raw);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(raw, i);
                if (i > 0) {
                    b.append(";");
                }
                String str = this.parameterToString(name + "[" + i + "]", arrayType, pattern, o);
                b.append(quoter.doQuoting(str));
            }
            return b.toString();
        }
        throw new ReportDataFactoryException("Unknown type " + type + " for parameter " + name);
    }

    private String getURLEncoding() {
        Configuration configuration = this.context.getConfiguration();
        return configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.URLEncoding");
    }

    protected String encodeParameter(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "";
        }
        try {
            return URLEncoder.encode((String)value, (String)this.getURLEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String createURL(String method, Map<String, String> extraParameter) {
        String baseURL = this.getBaseUrl();
        String basePath = this.isSugarMode() ? "/plugin/cda/api/" : "/content/cda/";
        StringBuilder url = new StringBuilder();
        url.append(baseURL);
        url.append(basePath);
        url.append(method);
        url.append("?");
        url.append("outputType=xml");
        url.append("&path=");
        url.append(this.encodeParameter(this.getPath()));
        if (!this.isSugarMode()) {
            url.append("&solution=");
            url.append(this.encodeParameter(this.getSolution()));
            url.append("&file=");
            url.append(this.encodeParameter(this.getFile()));
        }
        for (Map.Entry<String, String> entry : extraParameter.entrySet()) {
            String key = this.encodeParameter(entry.getKey());
            if (StringUtils.isEmpty((String)key)) continue;
            url.append("&");
            url.append(key);
            url.append("=");
            url.append(this.encodeParameter(entry.getValue()));
        }
        return url.toString();
    }

    protected TypedTableModel fetchParameter(DataRow dataRow, CdaQueryEntry realQuery) throws ReportDataFactoryException {
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put(DATA_ACCESS_ID, realQuery.getId());
        return this.fetchData(dataRow, METHOD_LIST_PARAMETERS, extras);
    }

    public synchronized TableModel queryData(CdaQueryEntry realQuery, DataRow parameters) throws ReportDataFactoryException {
        if (realQuery == null) {
            throw new NullPointerException("Query is null.");
        }
        TypedTableModel parameterModel = this.fetchParameter(parameters, realQuery);
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put(DATA_ACCESS_ID, realQuery.getId());
        int nameIdx = parameterModel.findColumn(PARAM_NAME);
        int typeIdx = parameterModel.findColumn(PARAM_TYPE);
        int defaultValueIdx = parameterModel.findColumn(PARAM_DEFAULT_VALUE);
        int patternIdx = parameterModel.findColumn(PARAM_PATTERN);
        for (int p = 0; p < parameterModel.getRowCount(); ++p) {
            String name = (String)parameterModel.getValueAt(p, nameIdx);
            String type = (String)parameterModel.getValueAt(p, typeIdx);
            String pattern = (String)parameterModel.getValueAt(p, patternIdx);
            String aliasName = this.findParameterAlias(realQuery, name);
            Object rawValue = parameters.get(aliasName);
            String param = rawValue == null ? (String)parameterModel.getValueAt(p, defaultValueIdx) : this.parameterToString(name, type, pattern, rawValue);
            extraParams.put("param" + name, param);
        }
        return this.fetchData(parameters, METHOD_DO_QUERY, extraParams);
    }

    private String findParameterAlias(CdaQueryEntry query, String name) {
        ParameterMapping[] parameterMapping = query.getParameters();
        for (int i = 0; i < parameterMapping.length; ++i) {
            ParameterMapping mapping = parameterMapping[i];
            if (!name.equals(mapping.getAlias())) continue;
            return mapping.getName();
        }
        return name;
    }

    public abstract TypedTableModel fetchData(DataRow var1, String var2, Map<String, String> var3) throws ReportDataFactoryException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException(cne);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isSugarMode() {
        return this.sugarMode;
    }

    public void setSugarMode(boolean sugarMode) {
        this.sugarMode = sugarMode;
    }

    public void cancelRunningQuery() {
    }
}

