/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.packager.dependencies;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.packager.dependencies.CssUrlReplacer;
import pt.webdetails.cpf.packager.dependencies.FileDependency;
import pt.webdetails.cpf.packager.dependencies.PackagedFileDependency;
import pt.webdetails.cpf.packager.origin.PathOrigin;
import pt.webdetails.cpf.repository.api.IRWAccess;

public class CssMinifiedDependency
extends PackagedFileDependency {
    private static Log logger = LogFactory.getLog(CssMinifiedDependency.class);

    public CssMinifiedDependency(PathOrigin origin, String path, IRWAccess writer, Iterable<FileDependency> inputFiles, IUrlProvider urlProvider) {
        super(origin, path, writer, inputFiles, urlProvider);
    }

    @Override
    protected InputStream minifyPackage(Iterable<FileDependency> inputFiles) {
        return new SequenceInputStream(new CssReplacementStreamEnumeration(inputFiles.iterator()));
    }

    public static class CssReplacementStreamEnumeration
    implements Enumeration<InputStream> {
        private Iterator<FileDependency> deps;
        private CssUrlReplacer replacer;

        public CssReplacementStreamEnumeration(Iterator<FileDependency> deps) {
            this.deps = deps;
            this.replacer = new CssUrlReplacer();
        }

        @Override
        public boolean hasMoreElements() {
            return this.deps.hasNext();
        }

        @Override
        public InputStream nextElement() {
            FileDependency dep = this.deps.next();
            try {
                String contents = Util.toString(dep.getFileInputStream());
                String originalUrlPath = FilenameUtils.getFullPath((String)dep.getUrlFilePath());
                contents = this.replacer.processContents(contents, originalUrlPath);
                return Util.toInputStream(contents);
            }
            catch (IOException e) {
                logger.error((Object)("Error getting input stream for dependency " + dep + ". Skipping.."), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)("Error with dependency " + dep + ". Skipping.."), (Throwable)e);
            }
            return Util.toInputStream("");
        }
    }
}

