/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.repository.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public abstract class ClassLoaderResourceAccess
implements IReadAccess {
    protected final String basePath;
    protected final ClassLoader classLoader;

    public ClassLoaderResourceAccess(ClassLoader classLoader, String basePath) {
        this.classLoader = classLoader;
        this.basePath = basePath == null ? "" : basePath;
    }

    @Override
    public InputStream getFileInputStream(String path) throws IOException {
        URL url = RepositoryHelper.getClosestResource(this.classLoader, path = FilenameUtils.normalize((String)RepositoryHelper.appendPath(this.basePath, path)));
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    @Override
    public boolean fileExists(String path) {
        return RepositoryHelper.getClosestResource(this.classLoader, path = FilenameUtils.normalize((String)RepositoryHelper.appendPath(this.basePath, path))) != null;
    }

    @Override
    public long getLastModified(String path) {
        URL url = RepositoryHelper.getClosestResource(this.classLoader, path);
        if (url != null) {
            File file = new File(url.getPath());
            return file.lastModified();
        }
        return 0L;
    }
}

