/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.ping.replication;

import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.IndexReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingRequest;
import org.elasticsearch.action.admin.cluster.ping.replication.ShardReplicationPingResponse;
import org.elasticsearch.action.admin.cluster.ping.replication.TransportShardReplicationPingAction;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndexReplicationPingAction
extends TransportIndexReplicationOperationAction<IndexReplicationPingRequest, IndexReplicationPingResponse, ShardReplicationPingRequest, ShardReplicationPingResponse> {
    @Inject
    public TransportIndexReplicationPingAction(Settings settings, ClusterService clusterService, TransportService transportService, ThreadPool threadPool, TransportShardReplicationPingAction shardReplicationPingAction) {
        super(settings, transportService, clusterService, threadPool, shardReplicationPingAction);
    }

    @Override
    protected IndexReplicationPingRequest newRequestInstance() {
        return new IndexReplicationPingRequest();
    }

    @Override
    protected IndexReplicationPingResponse newResponseInstance(IndexReplicationPingRequest request, AtomicReferenceArray shardsResponses) {
        int successfulShards = 0;
        int failedShards = 0;
        for (int i = 0; i < shardsResponses.length(); ++i) {
            if (shardsResponses.get(i) == null) {
                ++failedShards;
                continue;
            }
            ++successfulShards;
        }
        return new IndexReplicationPingResponse(request.index(), successfulShards, failedShards);
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    @Override
    protected String transportAction() {
        return "ping/replication/index";
    }

    @Override
    protected GroupShardsIterator shards(IndexReplicationPingRequest indexRequest) {
        IndexRoutingTable indexRouting = this.clusterService.state().routingTable().index(indexRequest.index());
        if (indexRouting == null) {
            throw new IndexMissingException(new Index(indexRequest.index()));
        }
        return indexRouting.groupByShardsIt();
    }

    @Override
    protected ShardReplicationPingRequest newShardRequestInstance(IndexReplicationPingRequest indexRequest, int shardId) {
        return new ShardReplicationPingRequest(indexRequest, shardId);
    }
}

