/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.BaseAction;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public abstract class TransportIndicesReplicationOperationAction<Request extends IndicesReplicationOperationRequest, Response extends ActionResponse, IndexRequest extends IndexReplicationOperationRequest, IndexResponse extends ActionResponse, ShardRequest extends ShardReplicationOperationRequest, ShardResponse extends ActionResponse>
extends BaseAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportIndexReplicationOperationAction<IndexRequest, IndexResponse, ShardRequest, ShardResponse> indexAction;
    final String transportAction;

    @Inject
    public TransportIndicesReplicationOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportIndexReplicationOperationAction<IndexRequest, IndexResponse, ShardRequest, ShardResponse> indexAction) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.indexAction = indexAction;
        this.transportAction = this.transportAction();
        transportService.registerHandler(this.transportAction, new TransportHandler());
    }

    @Override
    protected void doExecute(Request request, final ActionListener<Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        ((IndicesReplicationOperationRequest)request).indices(clusterState.metaData().concreteIndices(((IndicesReplicationOperationRequest)request).indices()));
        this.checkBlock(request, clusterState);
        String[] indices = ((IndicesReplicationOperationRequest)request).indices();
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(indices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(indices.length);
        for (String index : indices) {
            IndexRequest indexRequest = this.newIndexRequestInstance(request, index);
            ((IndexReplicationOperationRequest)indexRequest).listenerThreaded(false);
            this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>((IndicesReplicationOperationRequest)request){
                final /* synthetic */ IndicesReplicationOperationRequest val$request;
                {
                    this.val$request = indicesReplicationOperationRequest;
                }

                @Override
                public void onResponse(IndexResponse result) {
                    indexResponses.set(indexCounter.getAndIncrement(), result);
                    if (completionCounter.decrementAndGet() == 0) {
                        listener.onResponse(TransportIndicesReplicationOperationAction.this.newResponseInstance(this.val$request, indexResponses));
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    e.printStackTrace();
                    int index = indexCounter.getAndIncrement();
                    if (TransportIndicesReplicationOperationAction.this.accumulateExceptions()) {
                        indexResponses.set(index, e);
                    }
                    if (completionCounter.decrementAndGet() == 0) {
                        listener.onResponse(TransportIndicesReplicationOperationAction.this.newResponseInstance(this.val$request, indexResponses));
                    }
                }
            });
        }
    }

    protected abstract Request newRequestInstance();

    protected abstract Response newResponseInstance(Request var1, AtomicReferenceArray var2);

    protected abstract String transportAction();

    protected abstract IndexRequest newIndexRequestInstance(Request var1, String var2);

    protected abstract boolean accumulateExceptions();

    protected void checkBlock(Request request, ClusterState state) {
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportIndicesReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((IndicesReplicationOperationRequest)request).listenerThreaded(false);
            TransportIndicesReplicationOperationAction.this.execute(request, new ActionListener<Response>((IndicesReplicationOperationRequest)request){
                final /* synthetic */ IndicesReplicationOperationRequest val$request;
                {
                    this.val$request = indicesReplicationOperationRequest;
                }

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((Streamable)result);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportIndicesReplicationOperationAction.this.logger.warn("Failed to send error response for action [" + TransportIndicesReplicationOperationAction.this.transportAction + "] and request [" + this.val$request + "]", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

