/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class IndexTemplateMetaData {
    private final String name;
    private final int order;
    private final String template;
    private final Settings settings;
    private final ImmutableMap<String, CompressedString> mappings;

    public IndexTemplateMetaData(String name, int order, String template, Settings settings, ImmutableMap<String, CompressedString> mappings) {
        this.name = name;
        this.order = order;
        this.template = template;
        this.settings = settings;
        this.mappings = mappings;
    }

    public String name() {
        return this.name;
    }

    public int order() {
        return this.order;
    }

    public int getOrder() {
        return this.order();
    }

    public String getName() {
        return this.name;
    }

    public String template() {
        return this.template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableMap<String, CompressedString> mappings() {
        return this.mappings;
    }

    public ImmutableMap<String, CompressedString> getMappings() {
        return this.mappings;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder {
        private String name;
        private int order;
        private String template;
        private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private MapBuilder<String, CompressedString> mappings = MapBuilder.newMapBuilder();

        public Builder(String name) {
            this.name = name;
        }

        public Builder(IndexTemplateMetaData indexTemplateMetaData) {
            this(indexTemplateMetaData.name());
            this.order(indexTemplateMetaData.order());
            this.template(indexTemplateMetaData.template());
            this.settings(indexTemplateMetaData.settings());
            this.mappings.putAll(indexTemplateMetaData.mappings());
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public String template() {
            return this.template;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        public Builder putMapping(String mappingType, CompressedString mappingSource) throws IOException {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public Builder putMapping(String mappingType, String mappingSource) throws IOException {
            this.mappings.put(mappingType, new CompressedString(mappingSource));
            return this;
        }

        public IndexTemplateMetaData build() {
            return new IndexTemplateMetaData(this.name, this.order, this.template, this.settings, this.mappings.immutableMap());
        }

        public static void toXContent(IndexTemplateMetaData indexTemplateMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexTemplateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("order", indexTemplateMetaData.order());
            builder.field("template", indexTemplateMetaData.template());
            builder.startObject("settings");
            for (Map.Entry entry : indexTemplateMetaData.settings().getAsMap().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
            builder.startArray("mappings");
            for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                byte[] data = ((CompressedString)entry.getValue()).uncompressed();
                XContentParser parser = XContentFactory.xContent(data).createParser(data);
                Map<String, Object> mapping = parser.map();
                parser.close();
                builder.map(mapping);
            }
            builder.endArray();
            builder.endObject();
        }

        public static IndexTemplateMetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            String key = parser.currentName();
                            token = parser.nextToken();
                            String value = parser.text();
                            settingsBuilder.put(key, value);
                        }
                        builder.settings(settingsBuilder.build());
                        continue;
                    }
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Map<String, Object> mapping = parser.map();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        String mappingSource = XContentFactory.jsonBuilder().map(mapping).string();
                        if (mappingSource == null) continue;
                        builder.putMapping(mappingType, mappingSource);
                    }
                    continue;
                }
                if (!token.isValue()) continue;
                if ("template".equals(currentFieldName)) {
                    builder.template(parser.text());
                    continue;
                }
                if (!"order".equals(currentFieldName)) continue;
                builder.order(parser.intValue());
            }
            return builder.build();
        }

        public static IndexTemplateMetaData readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder(in.readUTF());
            builder.order(in.readInt());
            builder.template(in.readUTF());
            builder.settings(ImmutableSettings.readSettingsFromStream(in));
            int mappingsSize = in.readVInt();
            for (int i = 0; i < mappingsSize; ++i) {
                builder.putMapping(in.readUTF(), CompressedString.readCompressedString(in));
            }
            return builder.build();
        }

        public static void writeTo(IndexTemplateMetaData indexTemplateMetaData, StreamOutput out) throws IOException {
            out.writeUTF(indexTemplateMetaData.name());
            out.writeInt(indexTemplateMetaData.order());
            out.writeUTF(indexTemplateMetaData.template());
            ImmutableSettings.writeSettingsToStream(indexTemplateMetaData.settings(), out);
            out.writeVInt(indexTemplateMetaData.mappings().size());
            for (Map.Entry entry : indexTemplateMetaData.mappings().entrySet()) {
                out.writeUTF((String)entry.getKey());
                ((CompressedString)entry.getValue()).writeTo(out);
            }
        }
    }
}

