/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.settings.IndexSettings;

@AnalysisSettingsRequired
public class SynonymTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final SynonymMap synonymMap;

    @Inject
    public SynonymTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, Map<String, TokenizerFactoryFactory> tokenizerFactories, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        List<String> rules = Analysis.getWordList(env, settings, "synonyms");
        if (rules == null) {
            throw new ElasticSearchIllegalArgumentException("synonym requires either `synonyms` or `synonyms_path` to be configured");
        }
        boolean ignoreCase = settings.getAsBoolean("ignore_case", false);
        boolean expand = settings.getAsBoolean("expand", true);
        TokenizerFactoryFactory tokenizerFactoryFactory = tokenizerFactories.get(settings.get("tokenizer", "whitespace"));
        TokenizerFactory tokenizerFactory = tokenizerFactoryFactory.create(settings.get("tokenizer", "whitespace"), settings);
        this.synonymMap = new SynonymMap(ignoreCase);
        SynonymTokenFilterFactory.parseRules(rules, this.synonymMap, "=>", ",", expand, tokenizerFactory);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new SynonymFilter(tokenStream, this.synonymMap);
    }

    static void parseRules(List<String> rules, SynonymMap map, String mappingSep, String synSep, boolean expansion, TokenizerFactory tokFactory) {
        int count = 0;
        for (String rule : rules) {
            List<List<String>> target;
            List<List<String>> source;
            List<String> mapping = Strings.splitSmart(rule, mappingSep, false);
            if (mapping.size() > 2) {
                throw new RuntimeException("Invalid Synonym Rule:" + rule);
            }
            if (mapping.size() == 2) {
                source = SynonymTokenFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                target = SynonymTokenFilterFactory.getSynList(mapping.get(1), synSep, tokFactory);
            } else {
                source = SynonymTokenFilterFactory.getSynList(mapping.get(0), synSep, tokFactory);
                if (expansion) {
                    target = source;
                } else {
                    target = new ArrayList<List<String>>(1);
                    target.add(source.get(0));
                }
            }
            boolean includeOrig = false;
            for (List<String> fromToks : source) {
                ++count;
                for (List<String> toToks : target) {
                    map.add(fromToks, SynonymMap.makeTokens(toToks), includeOrig, true);
                }
            }
        }
    }

    private static List<List<String>> getSynList(String str, String separator, TokenizerFactory tokFactory) {
        List<String> strList = Strings.splitSmart(str, separator, false);
        ArrayList<List<String>> synList = new ArrayList<List<String>>();
        for (String toks : strList) {
            List<String> tokList = tokFactory == null ? Strings.splitWS(toks, true) : SynonymTokenFilterFactory.splitByTokenizer(toks, tokFactory);
            synList.add(tokList);
        }
        return synList;
    }

    private static List<String> splitByTokenizer(String source, TokenizerFactory tokFactory) {
        Tokenizer ts = tokFactory.create(new FastStringReader(source));
        ArrayList<String> tokList = new ArrayList<String>();
        try {
            CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
            while (ts.incrementToken()) {
                if (termAtt.length() <= 0) continue;
                tokList.add(termAtt.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tokList;
    }
}

