/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.longs;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.longs.LongFieldData;
import org.elasticsearch.index.field.data.longs.LongFieldDataComparator;
import org.elasticsearch.index.field.data.longs.LongFieldDataMissingComparator;

public class LongFieldDataType
implements FieldDataType<LongFieldData> {
    @Override
    public FieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, final String missing) {
        if (missing == null) {
            return new FieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new LongFieldDataComparator(numHits, fieldname, cache);
                }
            };
        }
        if (missing.equals("_last")) {
            return new FieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new LongFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Long.MIN_VALUE : Long.MAX_VALUE);
                }
            };
        }
        if (missing.equals("_first")) {
            return new FieldComparatorSource(){

                public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                    return new LongFieldDataMissingComparator(numHits, fieldname, cache, reversed ? Long.MAX_VALUE : Long.MIN_VALUE);
                }
            };
        }
        return new FieldComparatorSource(){

            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new LongFieldDataMissingComparator(numHits, fieldname, cache, Long.parseLong(missing));
            }
        };
    }

    @Override
    public LongFieldData load(IndexReader reader, String fieldName) throws IOException {
        return LongFieldData.load(reader, fieldName);
    }
}

