/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.field.data.strings;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.strings.StringFieldData;
import org.elasticsearch.index.field.data.strings.StringOrdValFieldDataComparator;

public class StringFieldDataType
implements FieldDataType<StringFieldData> {
    @Override
    public FieldComparatorSource newFieldComparatorSource(final FieldDataCache cache, String missing) {
        if (missing != null) {
            throw new ElasticSearchIllegalArgumentException("Sorting on string type field does not support missing parameter");
        }
        return new FieldComparatorSource(){

            public FieldComparator newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new StringOrdValFieldDataComparator(numHits, fieldname, sortPos, reversed, cache);
            }
        };
    }

    @Override
    public StringFieldData load(IndexReader reader, String fieldName) throws IOException {
        return StringFieldData.load(reader, fieldName);
    }
}

