/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class ProcessStats
implements Streamable,
Serializable,
ToXContent {
    long timestamp = -1L;
    Cpu cpu = null;
    Mem mem = null;
    Fd fd;

    ProcessStats() {
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    public Fd fd() {
        return this.fd;
    }

    public Fd getFd() {
        return this.fd();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("process");
        builder.field("timestamp", this.timestamp);
        if (this.cpu != null) {
            builder.startObject("cpu");
            builder.field("percent", (int)this.cpu.percent());
            builder.field("sys", this.cpu.sys().format());
            builder.field("sys_in_millis", this.cpu.sys().millis());
            builder.field("user", this.cpu.user().format());
            builder.field("user_in_millis", this.cpu.user().millis());
            builder.field("total", this.cpu.total().format());
            builder.field("total_in_millis", this.cpu.total().millis());
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject("mem");
            builder.field("resident", this.mem.resident().toString());
            builder.field("resident_in_bytes", this.mem.resident().bytes());
            builder.field("share", this.mem.share().toString());
            builder.field("share_in_bytes", this.mem.share().bytes());
            builder.field("total_virtual", this.mem.totalVirtual().toString());
            builder.field("total_virtual_in_bytes", this.mem.totalVirtual().bytes());
            builder.endObject();
        }
        if (this.fd != null) {
            builder.startObject("fd");
            builder.field("total", this.fd.total());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ProcessStats readProcessStats(StreamInput in) throws IOException {
        ProcessStats stats = new ProcessStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
        if (in.readBoolean()) {
            this.fd = Fd.readFd(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
        if (this.fd == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.fd.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        short percent = (short)-1;
        long sys = -1L;
        long user = -1L;
        long total = -1L;

        Cpu() {
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.sys = in.readLong();
            this.user = in.readLong();
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            out.writeLong(this.sys);
            out.writeLong(this.user);
            out.writeLong(this.total);
        }

        public short percent() {
            return this.percent;
        }

        public short getPercent() {
            return this.percent();
        }

        public TimeValue sys() {
            return new TimeValue(this.sys);
        }

        public TimeValue getSys() {
            return this.sys();
        }

        public TimeValue user() {
            return new TimeValue(this.user);
        }

        public TimeValue total() {
            return new TimeValue(this.total);
        }

        public TimeValue getTotal() {
            return this.total();
        }

        public TimeValue getUser() {
            return this.user();
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long totalVirtual = -1L;
        long resident = -1L;
        long share = -1L;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.totalVirtual = in.readLong();
            this.resident = in.readLong();
            this.share = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalVirtual);
            out.writeLong(this.resident);
            out.writeLong(this.share);
        }

        public ByteSizeValue totalVirtual() {
            return new ByteSizeValue(this.totalVirtual);
        }

        public ByteSizeValue getTotalVirtual() {
            return this.totalVirtual();
        }

        public ByteSizeValue resident() {
            return new ByteSizeValue(this.resident);
        }

        public ByteSizeValue getResident() {
            return this.resident();
        }

        public ByteSizeValue share() {
            return new ByteSizeValue(this.share);
        }

        public ByteSizeValue getShare() {
            return this.share();
        }
    }

    public static class Fd
    implements Streamable,
    Serializable {
        long total = -1L;

        Fd() {
        }

        public static Fd readFd(StreamInput in) throws IOException {
            Fd fd = new Fd();
            fd.readFrom(in);
            return fd;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.total);
        }

        public long total() {
            return this.total;
        }

        public long getTotal() {
            return this.total();
        }
    }
}

