/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel;

import com.orientechnologies.common.concur.resource.OAdaptiveLock;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.profiler.OJVMProfiler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OChannel {
    private static final OJVMProfiler PROFILER = Orient.instance().getProfiler();
    public Socket socket;
    public InputStream inStream;
    public OutputStream outStream;
    protected final OAdaptiveLock lockRead = new OAdaptiveLock();
    protected final OAdaptiveLock lockWrite = new OAdaptiveLock();
    protected long timeout;
    public int socketBufferSize;
    private long metricTransmittedBytes = 0L;
    private long metricReceivedBytes = 0L;
    private long metricFlushes = 0L;
    private static final AtomicLong metricGlobalTransmittedBytes = new AtomicLong();
    private static final AtomicLong metricGlobalReceivedBytes = new AtomicLong();
    private static final AtomicLong metricGlobalFlushes = new AtomicLong();
    private String profilerMetric;

    public OChannel(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        this.socket = iSocket;
        this.socketBufferSize = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_BUFFER_SIZE);
        this.socket.setTcpNoDelay(true);
    }

    public void acquireWriteLock() {
        this.lockWrite.lock();
    }

    public void releaseWriteLock() {
        this.lockWrite.unlock();
    }

    public void acquireReadLock() {
        this.lockRead.lock();
    }

    public void releaseReadLock() {
        this.lockRead.unlock();
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void close() {
        PROFILER.unregisterHookValue(this.profilerMetric + ".transmittedBytes");
        PROFILER.unregisterHookValue(this.profilerMetric + ".receivedBytes");
        PROFILER.unregisterHookValue(this.profilerMetric + ".flushes");
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void connected() {
        this.profilerMetric = PROFILER.getProcessMetric("network.channel.binary." + this.socket.getRemoteSocketAddress().toString() + this.socket.getLocalPort() + "".replace('.', '_'));
        PROFILER.registerHookValue(this.profilerMetric + ".transmittedBytes", "Bytes transmitted to a network channel", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OChannel.this.metricTransmittedBytes;
            }
        });
        PROFILER.registerHookValue(this.profilerMetric + ".receivedBytes", "Bytes received from a network channel", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OChannel.this.metricReceivedBytes;
            }
        });
        PROFILER.registerHookValue(this.profilerMetric + ".flushes", "Number of times the network channel has been flushed", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OChannel.this.metricFlushes;
            }
        });
    }

    public String toString() {
        return this.socket != null ? this.socket.getRemoteSocketAddress().toString() : "Not connected";
    }

    protected void updateMetricTransmittedBytes(int iDelta) {
        metricGlobalTransmittedBytes.addAndGet(iDelta);
        this.metricTransmittedBytes += (long)iDelta;
    }

    protected void updateMetricReceivedBytes(int iDelta) {
        metricGlobalReceivedBytes.addAndGet(iDelta);
        this.metricReceivedBytes += (long)iDelta;
    }

    protected void updateMetricFlushes() {
        metricGlobalFlushes.incrementAndGet();
        ++this.metricFlushes;
    }

    static {
        String profilerMetric = PROFILER.getProcessMetric("network.channel.binary");
        PROFILER.registerHookValue(profilerMetric + ".transmittedBytes", "Bytes transmitted to all the network channels", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricGlobalTransmittedBytes.get();
            }
        });
        PROFILER.registerHookValue(profilerMetric + ".receivedBytes", "Bytes received from all the network channels", OProfiler.METRIC_TYPE.SIZE, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricGlobalReceivedBytes.get();
            }
        });
        PROFILER.registerHookValue(profilerMetric + ".flushes", "Number of times the network channels have been flushed", OProfiler.METRIC_TYPE.COUNTER, new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return metricGlobalFlushes.get();
            }
        });
    }
}

