/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;

public class OAsynchChannelServiceThread
extends OSoftThread {
    private OChannelBinaryClient network;
    private int sessionId = Integer.MIN_VALUE;
    private ORemoteServerEventListener remoteServerEventListener;

    public OAsynchChannelServiceThread(ORemoteServerEventListener iRemoteServerEventListener, OChannelBinaryClient iChannel) {
        super(Orient.instance().getThreadGroup(), "OrientDB <- Asynch Client (" + iChannel.socket.getRemoteSocketAddress() + ")");
        this.remoteServerEventListener = iRemoteServerEventListener;
        this.network = iChannel;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            this.network.beginResponse(this.sessionId, 0L);
            byte request = this.network.readByte();
            Object obj = null;
            switch (request) {
                case 79: {
                    obj = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable(this.network);
                    break;
                }
                case 80: {
                    obj = this.network.readBytes();
                }
            }
            if (this.remoteServerEventListener != null) {
                this.remoteServerEventListener.onRequest(request, obj);
            }
        }
        catch (IOException ioe) {
            this.sendShutdown();
            if (this.network != null) {
                OChannelBinaryClient n = this.network;
                this.network = null;
                n.close();
            }
        }
        finally {
            if (this.network != null) {
                this.network.endResponse();
            }
        }
    }
}

