/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

public class OChannelBinaryAsynch
extends OChannelBinary {
    private final Condition readCondition;
    private volatile boolean channelRead;
    private byte currentStatus;
    private int currentSessionId;
    private final int maxUnreadResponses;

    public OChannelBinaryAsynch(Socket iSocket, OContextConfiguration iConfig) throws IOException {
        super(iSocket, iConfig);
        this.readCondition = this.lockRead.getUnderlying().newCondition();
        this.channelRead = false;
        this.maxUnreadResponses = OGlobalConfiguration.NETWORK_BINARY_READ_RESPONSE_MAX_TIMES.getValueAsInteger();
    }

    public void beginRequest() {
        this.acquireWriteLock();
    }

    public void endRequest() throws IOException {
        this.flush();
        this.releaseWriteLock();
    }

    public void beginResponse(int iRequesterId) throws IOException {
        this.beginResponse(iRequesterId, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void beginResponse(int iRequesterId, long iTimeout) throws IOException {
        try {
            unreadResponse = 0;
            v0 = startClock = iTimeout > 0L ? System.currentTimeMillis() : 0L;
            while (true) lbl-1000:
            // 5 sources

            {
                if (iTimeout <= 0L) {
                    this.acquireReadLock();
                } else if (!this.lockRead.tryAcquireLock(iTimeout, TimeUnit.MILLISECONDS)) {
                    throw new OTimeoutException("Cannot acquire read lock against channel: " + this);
                }
                if (!this.channelRead) {
                    this.channelRead = true;
                    try {
                        this.currentStatus = this.readByte();
                        this.currentSessionId = this.readInt();
                        if (this.debug) {
                            OLogManager.instance().debug((Object)this, "%s - Read response: %d-%d", new Object[]{this.socket.getLocalAddress(), (int)this.currentStatus, this.currentSessionId});
                        }
                    }
                    catch (IOException e) {
                        this.channelRead = false;
                        this.readCondition.signalAll();
                        this.releaseReadLock();
                        throw e;
                    }
                }
                if (this.currentSessionId == iRequesterId) ** break;
                try {
                    if (this.debug) {
                        OLogManager.instance().debug((Object)this, "%s - Session %d skip response, it is for %d", new Object[]{this.socket.getLocalAddress(), iRequesterId, this.currentSessionId});
                    }
                    if (iTimeout > 0L && System.currentTimeMillis() - startClock > iTimeout) {
                        this.close();
                        throw new OTimeoutException("Timeout on reading response from the server " + (this.socket != null ? this.socket.getRemoteSocketAddress() : "") + " for the request " + iRequesterId);
                    }
                    if (unreadResponse > this.maxUnreadResponses) {
                        if (this.debug) {
                            OLogManager.instance().info((Object)this, "Unread responses %d > %d, consider the buffer as dirty: clean it", new Object[]{unreadResponse, this.maxUnreadResponses});
                        }
                        this.close();
                        throw new IOException("Timeout on reading response");
                    }
                    this.readCondition.signalAll();
                    if (this.debug) {
                        OLogManager.instance().debug((Object)this, "Session %d is going to sleep...", new Object[]{iRequesterId});
                    }
                    start = System.currentTimeMillis();
                    this.readCondition.await(1L, TimeUnit.SECONDS);
                    now = System.currentTimeMillis();
                    if (this.debug) {
                        OLogManager.instance().debug((Object)this, "Waked up: slept %dms, checking again from %s for session %d", new Object[]{now - start, this.socket.getLocalAddress(), iRequesterId});
                    }
                    if (now - start < 1000L) ** GOTO lbl-1000
                    ++unreadResponse;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    this.releaseReadLock();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (this.debug) {
                OLogManager.instance().debug((Object)this, "%s - Session %d handle response", new Object[]{this.socket.getLocalAddress(), iRequesterId});
            }
            this.handleStatus(this.currentStatus, this.currentSessionId);
        }
        catch (OLockException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
    }

    public void endResponse() {
        this.channelRead = false;
        try {
            this.readCondition.signalAll();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().debug((Object)this, "Error on signaling waiting clients after reading response", new Object[0]);
        }
        try {
            this.releaseReadLock();
        }
        catch (IllegalMonitorStateException e) {
            OLogManager.instance().debug((Object)this, "Error on unlocking network channel after reading response", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.lockRead.tryAcquireLock()) {
            try {
                this.readCondition.signalAll();
            }
            finally {
                this.releaseReadLock();
            }
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInput() throws IOException {
        this.acquireReadLock();
        try {
            super.clearInput();
        }
        finally {
            this.releaseReadLock();
        }
    }
}

