/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.scostore;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.JDBCUtils;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.exceptions.MappedDatastoreException;
import org.datanucleus.store.rdbms.mapping.MappingHelper;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedElementPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.scostore.BackingStoreHelper;
import org.datanucleus.store.rdbms.scostore.ElementContainerStore;
import org.datanucleus.store.rdbms.table.JoinTable;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.scostore.CollectionStore;

public abstract class AbstractCollectionStore
extends ElementContainerStore
implements CollectionStore {
    protected String containsStmt;

    protected AbstractCollectionStore(RDBMSStoreManager storeMgr, ClassLoaderResolver clr) {
        super(storeMgr, clr);
    }

    public boolean updateEmbeddedElement(ObjectProvider op, Object element, int fieldNumber, Object value) {
        boolean modified = false;
        if (this.elementMapping != null && this.elementMapping instanceof EmbeddedElementPCMapping) {
            String fieldName = this.emd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getName();
            if (fieldName == null) {
                return false;
            }
            JavaTypeMapping fieldMapping = ((EmbeddedElementPCMapping)this.elementMapping).getJavaTypeMapping(fieldName);
            if (fieldMapping == null) {
                return false;
            }
            modified = this.updateEmbeddedElement(op, element, fieldNumber, value, fieldMapping);
        }
        return modified;
    }

    public void update(ObjectProvider op, Collection coll) {
        this.clear(op);
        this.addAll(op, coll, 0);
    }

    public boolean contains(ObjectProvider op, Object element) {
        if (!this.validateElementForReading(op, element)) {
            return false;
        }
        return this.containsInternal(op, element);
    }

    protected String getUpdateEmbeddedElementStmt(JavaTypeMapping fieldMapping) {
        JavaTypeMapping ownerMapping = this.getOwnerMapping();
        Table containerTable = this.getContainerTable();
        JavaTypeMapping elementMapping = this.getElementMapping();
        StringBuffer stmt = new StringBuffer("UPDATE ");
        stmt.append(containerTable.toString());
        stmt.append(" SET ");
        for (int i = 0; i < fieldMapping.getNumberOfDatastoreMappings(); ++i) {
            if (i > 0) {
                stmt.append(",");
            }
            stmt.append(fieldMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            stmt.append(" = ");
            stmt.append(((AbstractDatastoreMapping)fieldMapping.getDatastoreMapping(i)).getUpdateInputParameter());
        }
        stmt.append(" WHERE ");
        BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, null, true);
        EmbeddedElementPCMapping embeddedMapping = (EmbeddedElementPCMapping)elementMapping;
        for (int i = 0; i < embeddedMapping.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = embeddedMapping.getJavaTypeMapping(i);
            if (m == null) continue;
            for (int j = 0; j < m.getNumberOfDatastoreMappings(); ++j) {
                stmt.append(" AND ");
                stmt.append(m.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                stmt.append(" = ");
                stmt.append(((AbstractDatastoreMapping)m.getDatastoreMapping(j)).getUpdateInputParameter());
            }
        }
        return stmt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEmbeddedElement(ObjectProvider op, Object element, int fieldNumber, Object value, JavaTypeMapping fieldMapping) {
        boolean modified = false;
        String stmt = this.getUpdateEmbeddedElementStmt(fieldMapping);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForUpdate(mconn, stmt, false);
                try {
                    int jdbcPosition = 1;
                    fieldMapping.setObject(ec, ps, MappingHelper.getMappingIndices(jdbcPosition, fieldMapping), value);
                    jdbcPosition += fieldMapping.getNumberOfDatastoreMappings();
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateEmbeddedElementFieldsInStatement(op, element, ps, jdbcPosition, ((JoinTable)this.getContainerTable()).getOwnerMemberMetaData(), this.getElementMapping(), this.getEmd(), this);
                    sqlControl.executeStatementUpdate(ec, mconn, stmt, ps, true);
                    modified = true;
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(LOCALISER.msg("056009", (Object)stmt), (Throwable)e);
        }
        return modified;
    }

    private String getContainsStmt(Object element) {
        if (this.containsStmt == null) {
            JavaTypeMapping ownerMapping = this.getOwnerMapping();
            Table containerTable = this.getContainerTable();
            boolean elementsAreSerialised = this.isElementsAreSerialised();
            JavaTypeMapping elementMapping = this.getElementMapping();
            ElementContainerStore.ElementInfo[] elementInfo = this.getElementInfo();
            StringBuffer stmt = new StringBuffer("SELECT ");
            String containerAlias = "THIS";
            String joinedElementAlias = "ELEM";
            for (int i = 0; i < ownerMapping.getNumberOfDatastoreMappings(); ++i) {
                if (i > 0) {
                    stmt.append(",");
                }
                stmt.append(ownerMapping.getDatastoreMapping(i).getColumn().getIdentifier().toString());
            }
            stmt.append(" FROM ");
            stmt.append(this.getContainerTable().toString()).append(" ").append(containerAlias);
            boolean joinedDiscrim = false;
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, ownerMapping, containerAlias, true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, elementMapping, element, elementsAreSerialised, containerAlias, false);
            if (elementInfo != null && containerTable == elementInfo[0].getDatastoreClass() && elementInfo[0].getDiscriminatorMapping() != null) {
                stmt.append(" AND (");
                Collection subclasses = this.storeMgr.getSubClassesForClass(elementInfo[0].getClassName(), true, this.clr);
                for (int i = 0; i < subclasses.size() + 1; ++i) {
                    JavaTypeMapping discrimMapping = elementInfo[0].getDiscriminatorMapping();
                    for (int j = 0; j < discrimMapping.getNumberOfDatastoreMappings(); ++j) {
                        if (joinedDiscrim) {
                            stmt.append(joinedElementAlias);
                        } else {
                            stmt.append(containerAlias);
                        }
                        stmt.append(".").append(discrimMapping.getDatastoreMapping(j).getColumn().getIdentifier().toString());
                        stmt.append(" = ");
                        stmt.append(((AbstractDatastoreMapping)discrimMapping.getDatastoreMapping(j)).getUpdateInputParameter());
                        if (j == discrimMapping.getNumberOfDatastoreMappings() - 1 && i == subclasses.size()) continue;
                        stmt.append(" OR ");
                    }
                }
                stmt.append(")");
            }
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, containerAlias, false);
            }
            if (elementMapping instanceof ReferenceMapping && elementMapping.getNumberOfDatastoreMappings() > 1) {
                return stmt.toString();
            }
            this.containsStmt = stmt.toString();
        }
        return this.containsStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean containsInternal(ObjectProvider op, Object element) {
        boolean retval;
        Table containerTable = this.getContainerTable();
        JavaTypeMapping elementMapping = this.getElementMapping();
        ElementContainerStore.ElementInfo[] elementInfo = this.getElementInfo();
        String stmt = this.getContainsStmt(element);
        try {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            SQLController sqlControl = this.storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(mconn, stmt);
                try {
                    int jdbcPosition = 1;
                    jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
                    jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, elementMapping);
                    if (elementInfo != null && elementInfo[0].getDiscriminatorMapping() != null && elementInfo[0].getDatastoreClass() == containerTable) {
                        jdbcPosition = BackingStoreHelper.populateElementDiscriminatorInStatement(ec, ps, jdbcPosition, true, elementInfo[0], this.clr);
                    }
                    if (this.relationDiscriminatorMapping != null) {
                        jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
                    }
                    ResultSet rs = sqlControl.executeStatementQuery(ec, mconn, stmt, ps);
                    try {
                        retval = rs.next();
                        JDBCUtils.logWarnings(rs);
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(mconn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER.msg("056008", (Object)stmt), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] internalRemove(ObjectProvider op, ManagedConnection conn, boolean batched, Object element, boolean executeNow) throws MappedDatastoreException {
        int[] nArray;
        ExecutionContext ec = op.getExecutionContext();
        SQLController sqlControl = this.storeMgr.getSQLController();
        String removeStmt = this.getRemoveStmt(element);
        PreparedStatement ps = sqlControl.getStatementForUpdate(conn, removeStmt, batched);
        try {
            int jdbcPosition = 1;
            jdbcPosition = BackingStoreHelper.populateOwnerInStatement(op, ec, ps, jdbcPosition, this);
            jdbcPosition = BackingStoreHelper.populateElementForWhereClauseInStatement(ec, ps, element, jdbcPosition, this.elementMapping);
            if (this.relationDiscriminatorMapping != null) {
                jdbcPosition = BackingStoreHelper.populateRelationDiscriminatorInStatement(ec, ps, jdbcPosition, this);
            }
            nArray = sqlControl.executeStatementUpdate(ec, conn, removeStmt, ps, executeNow);
        }
        catch (Throwable throwable) {
            try {
                sqlControl.closeStatement(conn, ps);
                throw throwable;
            }
            catch (SQLException sqle) {
                throw new MappedDatastoreException("SQLException", sqle);
            }
        }
        sqlControl.closeStatement(conn, ps);
        return nArray;
    }

    protected String getRemoveStmt(Object element) {
        if (this.removeStmt == null) {
            StringBuffer stmt = new StringBuffer();
            stmt.append("DELETE FROM ");
            stmt.append(this.containerTable.toString());
            stmt.append(" WHERE ");
            BackingStoreHelper.appendWhereClauseForMapping(stmt, this.ownerMapping, this.containerTable.toString(), true);
            BackingStoreHelper.appendWhereClauseForElement(stmt, this.elementMapping, element, this.elementsAreSerialised, this.containerTable.toString(), false);
            if (this.relationDiscriminatorMapping != null) {
                BackingStoreHelper.appendWhereClauseForMapping(stmt, this.relationDiscriminatorMapping, this.containerTable.toString(), false);
            }
            if (this.elementMapping instanceof ReferenceMapping && this.elementMapping.getNumberOfDatastoreMappings() > 1) {
                return stmt.toString();
            }
            this.removeStmt = stmt.toString();
        }
        return this.removeStmt;
    }
}

