/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SlaveServer
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
VariableSpace,
RepositoryElementInterface,
XMLInterface {
    private static Class<?> PKG = SlaveServer.class;
    public static final String STRING_SLAVESERVER = "Slave Server";
    public static final String XML_TAG = "slaveserver";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.SLAVE_SERVER;
    private static final int NOT_FOUND_ERROR = 404;
    private LogChannelInterface log;
    private String name;
    private String hostname;
    private String port;
    private String webAppName;
    private String username;
    private String password;
    private String proxyHostname;
    private String proxyPort;
    private String nonProxyHosts;
    private boolean master;
    private boolean shared;
    private ObjectId id;
    private VariableSpace variables = new Variables();
    private ObjectRevision objectRevision;
    private Date changedDate;

    public SlaveServer() {
        this.initializeVariablesFrom(null);
        this.id = null;
        this.log = new LogChannel((Object)STRING_SLAVESERVER);
        this.changedDate = new Date();
    }

    public SlaveServer(String name, String hostname, String port, String username, String password) {
        this(name, hostname, port, username, password, null, null, null, false);
    }

    public SlaveServer(String name, String hostname, String port, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean master) {
        this();
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.proxyHostname = proxyHostname;
        this.proxyPort = proxyPort;
        this.nonProxyHosts = nonProxyHosts;
        this.master = master;
        this.initializeVariablesFrom(null);
        this.log = new LogChannel((Object)this);
    }

    public SlaveServer(Node slaveNode) {
        this();
        this.name = XMLHandler.getTagValue((Node)slaveNode, (String)"name");
        this.hostname = XMLHandler.getTagValue((Node)slaveNode, (String)"hostname");
        this.port = XMLHandler.getTagValue((Node)slaveNode, (String)"port");
        this.webAppName = XMLHandler.getTagValue((Node)slaveNode, (String)"webAppName");
        this.username = XMLHandler.getTagValue((Node)slaveNode, (String)"username");
        this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)slaveNode, (String)"password"));
        this.proxyHostname = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_hostname");
        this.proxyPort = XMLHandler.getTagValue((Node)slaveNode, (String)"proxy_port");
        this.nonProxyHosts = XMLHandler.getTagValue((Node)slaveNode, (String)"non_proxy_hosts");
        this.master = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)slaveNode, (String)"master"));
        this.initializeVariablesFrom(null);
        this.log = new LogChannel((Object)this);
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append("<").append(XML_TAG).append(">");
        xml.append(XMLHandler.addTagValue((String)"name", (String)this.name, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"port", (String)this.port, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"webAppName", (String)this.webAppName, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"username", (String)this.username, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"proxy_hostname", (String)this.proxyHostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"non_proxy_hosts", (String)this.nonProxyHosts, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"master", (boolean)this.master, (boolean)false));
        xml.append("</").append(XML_TAG).append(">");
        return xml.toString();
    }

    public Object clone() {
        SlaveServer slaveServer = new SlaveServer();
        slaveServer.replaceMeta(this);
        return slaveServer;
    }

    public void replaceMeta(SlaveServer slaveServer) {
        this.name = slaveServer.name;
        this.hostname = slaveServer.hostname;
        this.port = slaveServer.port;
        this.webAppName = slaveServer.webAppName;
        this.username = slaveServer.username;
        this.password = slaveServer.password;
        this.proxyHostname = slaveServer.proxyHostname;
        this.proxyPort = slaveServer.proxyPort;
        this.nonProxyHosts = slaveServer.nonProxyHosts;
        this.master = slaveServer.master;
        this.id = slaveServer.id;
        this.shared = slaveServer.shared;
        this.setChanged(true);
    }

    public String toString() {
        return this.name;
    }

    public String getServerAndPort() {
        String realHostname = this.environmentSubstitute(this.hostname);
        if (!Const.isEmpty((String)realHostname)) {
            return realHostname + this.getPortSpecification();
        }
        return STRING_SLAVESERVER;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SlaveServer)) {
            return false;
        }
        SlaveServer slave = (SlaveServer)obj;
        return this.name.equalsIgnoreCase(slave.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String urlString) {
        this.hostname = urlString;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWebAppName() {
        return this.webAppName;
    }

    public void setWebAppName(String webAppName) {
        this.webAppName = webAppName;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public void setProxyHostname(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getPortSpecification() {
        String realPort = this.environmentSubstitute(this.port);
        String portSpec = ":" + realPort;
        if (Const.isEmpty((String)realPort) || this.port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public String constructUrl(String serviceAndArguments) throws UnsupportedEncodingException {
        String realHostname = this.environmentSubstitute(this.hostname);
        if (!StringUtils.isEmpty((String)this.webAppName)) {
            serviceAndArguments = "/" + this.environmentSubstitute(this.getWebAppName()) + serviceAndArguments;
        }
        String retval = "http://" + realHostname + this.getPortSpecification() + serviceAndArguments;
        retval = Const.replace((String)retval, (String)" ", (String)"%20");
        return retval;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    PostMethod buildSendXMLMethod(byte[] content, String service) throws Exception {
        String urlString = this.constructUrl(service);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        PostMethod postMethod = new PostMethod(urlString);
        ByteArrayRequestEntity entity = new ByteArrayRequestEntity(content);
        postMethod.setRequestEntity((RequestEntity)entity);
        postMethod.setDoAuthentication(true);
        postMethod.addRequestHeader(new Header("Content-Type", "text/xml;charset=UTF-8"));
        return postMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String sendXML(String xml, String service) throws Exception {
        String string;
        PostMethod method = this.buildSendXMLMethod(xml.getBytes("UTF-8"), service);
        try {
            int result = this.getHttpClient().executeMethod((HttpMethod)method);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
            }
            String responseBody = this.getResponseBodyAsString(method.getResponseBodyAsStream());
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
            }
            if (result >= 400) {
                String message = result == 404 ? String.format("%s%s%s%s", BaseMessages.getString(PKG, (String)"SlaveServer.Error.404.Title", (String[])new String[0]), Const.CR, Const.CR, BaseMessages.getString(PKG, (String)"SlaveServer.Error.404.Message", (String[])new String[0])) : String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText());
                throw new KettleException(message);
            }
            string = responseBody;
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentXmlToService", (String[])new String[]{service, this.environmentSubstitute(this.hostname)}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentXmlToService", (String[])new String[]{service, this.environmentSubstitute(this.hostname)}));
        }
        return string;
    }

    PostMethod buildSendExportMethod(String type, String load, InputStream is) throws UnsupportedEncodingException {
        String serviceUrl = "/kettle/addExport";
        if (type != null && load != null) {
            serviceUrl = serviceUrl + "/?type=" + type + "&" + "load" + "=" + URLEncoder.encode(load, "UTF-8");
        }
        String urlString = this.constructUrl(serviceUrl);
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ConnectingTo", (String[])new String[]{urlString}));
        }
        PostMethod method = new PostMethod(urlString);
        method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(is));
        method.setDoAuthentication(true);
        method.addRequestHeader(new Header("Content-Type", "binary/zip"));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendExport(String filename, String type, String load) throws Exception {
        InputStream is = null;
        try {
            String string;
            is = KettleVFS.getInputStream((FileObject)KettleVFS.getFileObject((String)filename));
            PostMethod method = this.buildSendExportMethod(type, load, is);
            try {
                int result = this.getHttpClient().executeMethod((HttpMethod)method);
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
                }
                String responseBody = this.getResponseBodyAsString(method.getResponseBodyAsStream());
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
                }
                if (result >= 400) {
                    throw new KettleException(String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText()));
                }
                string = responseBody;
            }
            catch (Throwable throwable) {
                method.releaseConnection();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentExportToService", (String[])new String[]{"/kettle/addExport", this.environmentSubstitute(this.hostname)}));
                }
                throw throwable;
            }
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_SentExportToService", (String[])new String[]{"/kettle/addExport", this.environmentSubstitute(this.hostname)}));
            }
            return string;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    public void addProxy(HttpClient client) {
        String host = this.environmentSubstitute(this.hostname);
        String phost = this.environmentSubstitute(this.proxyHostname);
        String pport = this.environmentSubstitute(this.proxyPort);
        String nonprox = this.environmentSubstitute(this.nonProxyHosts);
        if (!Const.isEmpty((String)phost) && !Const.isEmpty((String)pport)) {
            if (!Const.isEmpty((String)nonprox) && !Const.isEmpty((String)host) && host.matches(nonprox)) {
                return;
            }
            client.getHostConfiguration().setProxy(phost, Integer.parseInt(pport));
        }
    }

    public void addCredentials(HttpClient client) {
        client.getState().setCredentials(new AuthScope(this.environmentSubstitute(this.hostname), Const.toInt((String)this.environmentSubstitute(this.port), (int)80)), (Credentials)new UsernamePasswordCredentials(this.environmentSubstitute(this.username), Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password))));
        client.getParams().setAuthenticationPreemptive(true);
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }

    public synchronized String execService(String service) throws Exception {
        return this.execService(service, new HashMap<String, String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getResponseBodyAsString(InputStream is) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
        StringBuilder bodyBuffer = new StringBuilder();
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                bodyBuffer.append(line);
            }
        }
        finally {
            bufferedReader.close();
        }
        return bodyBuffer.toString();
    }

    GetMethod buildExecuteServiceMethod(String service, Map<String, String> headerValues) throws UnsupportedEncodingException {
        GetMethod method = new GetMethod(this.constructUrl(service));
        for (String key : headerValues.keySet()) {
            method.setRequestHeader(key, headerValues.get(key));
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String execService(String service, Map<String, String> headerValues) throws Exception {
        String string;
        GetMethod method = this.buildExecuteServiceMethod(service, headerValues);
        try {
            int result = this.getHttpClient().executeMethod((HttpMethod)method);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseStatus", (String[])new String[]{Integer.toString(result)}));
            }
            String responseBody = this.getResponseBodyAsString(method.getResponseBodyAsStream());
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_FinishedReading", (String[])new String[]{Integer.toString(responseBody.getBytes().length)}));
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"SlaveServer.DEBUG_ResponseBody", (String[])new String[]{responseBody}));
            }
            if (result >= 400) {
                throw new KettleException(String.format("HTTP Status %d - %s - %s", method.getStatusCode(), method.getPath(), method.getStatusText()));
            }
            string = responseBody;
        }
        catch (Throwable throwable) {
            method.releaseConnection();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
            }
            throw throwable;
        }
        method.releaseConnection();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"SlaveServer.DETAILED_ExecutedService", (String[])new String[]{service, this.hostname}));
        }
        return string;
    }

    HttpClient getHttpClient() {
        HttpClient client = SlaveConnectionManager.getInstance().createHttpClient();
        this.addCredentials(client);
        this.addProxy(client);
        return client;
    }

    public SlaveServerStatus getStatus() throws Exception {
        String xml = this.execService("/kettle/status/?xml=Y");
        return SlaveServerStatus.fromXML(xml);
    }

    public List<SlaveServerDetection> getSlaveServerDetections() throws Exception {
        String xml = this.execService("/kettle/getSlaves/");
        Document document = XMLHandler.loadXMLString((String)xml);
        Node detectionsNode = XMLHandler.getSubNode((Node)document, (String)"SlaveServerDetections");
        int nrDetections = XMLHandler.countNodes((Node)detectionsNode, (String)"SlaveServerDetection");
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        for (int i = 0; i < nrDetections; ++i) {
            Node detectionNode = XMLHandler.getSubNodeByNr((Node)detectionsNode, (String)"SlaveServerDetection", (int)i);
            SlaveServerDetection detection = new SlaveServerDetection(detectionNode);
            detections.add(detection);
        }
        return detections;
    }

    public SlaveServerTransStatus getTransStatus(String transName, String carteObjectId, int startLogLineNr) throws Exception {
        String xml = this.execService("/kettle/transStatus/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr);
        return SlaveServerTransStatus.fromXML(xml);
    }

    public SlaveServerJobStatus getJobStatus(String jobName, String carteObjectId, int startLogLineNr) throws Exception {
        String xml = this.execService("/kettle/jobStatus/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y&from=" + startLogLineNr);
        return SlaveServerJobStatus.fromXML(xml);
    }

    public WebResult stopTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/stopTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult pauseResumeTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/pauseTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult removeTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/removeTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult removeJob(String jobName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/removeJob/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult stopJob(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/stopJob/?name=" + URLEncoder.encode(transName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)carteObjectId, (String)""));
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult startTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/startTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult startJob(String jobName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/startJob/?name=" + URLEncoder.encode(jobName, "UTF-8") + "&xml=Y&id=" + Const.NVL((String)carteObjectId, (String)""));
        return WebResult.fromXMLString((String)xml);
    }

    public WebResult cleanupTransformation(String transName, String carteObjectId) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)carteObjectId, (String)"") + "&xml=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public synchronized WebResult deAllocateServerSockets(String transName, String clusteredRunId) throws Exception {
        String xml = this.execService("/kettle/cleanupTrans/?name=" + URLEncoder.encode(transName, "UTF-8") + "&id=" + Const.NVL((String)clusteredRunId, (String)"") + "&xml=Y&sockets=Y");
        return WebResult.fromXMLString((String)xml);
    }

    public static SlaveServer findSlaveServer(List<SlaveServer> slaveServers, String name) {
        for (SlaveServer slaveServer : slaveServers) {
            if (slaveServer.getName() == null || !slaveServer.getName().equalsIgnoreCase(name)) continue;
            return slaveServer;
        }
        return null;
    }

    public static SlaveServer findSlaveServer(List<SlaveServer> slaveServers, ObjectId id) {
        for (SlaveServer slaveServer : slaveServers) {
            if (slaveServer.getObjectId() == null || !slaveServer.getObjectId().equals(id)) continue;
            return slaveServer;
        }
        return null;
    }

    public static String[] getSlaveServerNames(List<SlaveServer> slaveServers) {
        String[] names = new String[slaveServers.size()];
        for (int i = 0; i < slaveServers.size(); ++i) {
            SlaveServer slaveServer = slaveServers.get(i);
            names[i] = slaveServer.getName();
        }
        return names;
    }

    public synchronized int allocateServerSocket(String runId, int portRangeStart, String hostname, String transformationName, String sourceSlaveName, String sourceStepName, String sourceStepCopy, String targetSlaveName, String targetStepName, String targetStepCopy) throws Exception {
        InetAddress inetAddress = InetAddress.getByName(hostname);
        String address = inetAddress.getHostAddress();
        String service = "/kettle/allocateSocket/?";
        service = service + "rangeStart=" + Integer.toString(portRangeStart);
        service = service + "&id=" + URLEncoder.encode(runId, "UTF-8");
        service = service + "&host=" + address;
        service = service + "&trans=" + URLEncoder.encode(transformationName, "UTF-8");
        service = service + "&sourceSlave=" + URLEncoder.encode(sourceSlaveName, "UTF-8");
        service = service + "&sourceStep=" + URLEncoder.encode(sourceStepName, "UTF-8");
        service = service + "&sourceCopy=" + URLEncoder.encode(sourceStepCopy, "UTF-8");
        service = service + "&targetSlave=" + URLEncoder.encode(targetSlaveName, "UTF-8");
        service = service + "&targetStep=" + URLEncoder.encode(targetStepName, "UTF-8");
        service = service + "&targetCopy=" + URLEncoder.encode(targetStepCopy, "UTF-8");
        String xml = this.execService(service = service + "&xml=Y");
        Document doc = XMLHandler.loadXMLString((String)xml);
        String portString = XMLHandler.getTagValue((Node)doc, (String)"port");
        int port = Const.toInt((String)portString, (int)-1);
        if (port < 0) {
            throw new Exception("Unable to retrieve port from service : " + service + ", received : \n" + xml);
        }
        return port;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return new RepositoryDirectory();
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
        throw new RuntimeException("Setting a directory on a database connection is not supported");
    }

    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(String description) {
    }

    public String sniffStep(String transName, String stepName, String copyNr, int lines, String type) throws Exception {
        return this.execService("/kettle/sniffStep/?trans=" + URLEncoder.encode(transName, "UTF-8") + "&step=" + URLEncoder.encode(stepName, "UTF-8") + "&copynr=" + copyNr + "&type=" + type + "&lines=" + lines + "&xml=Y");
    }

    public long getNextSlaveSequenceValue(String slaveSequenceName, long incrementValue) throws KettleException {
        try {
            String xml = this.execService("/kettle/nextSequence/?name=" + URLEncoder.encode(slaveSequenceName, "UTF-8") + "&" + "increment" + "=" + Long.toString(incrementValue));
            Document doc = XMLHandler.loadXMLString((String)xml);
            Node seqNode = XMLHandler.getSubNode((Node)doc, (String)"seq");
            String nextValueString = XMLHandler.getTagValue((Node)seqNode, (String)"value");
            String errorString = XMLHandler.getTagValue((Node)seqNode, (String)"error");
            if (!Const.isEmpty((String)errorString)) {
                throw new KettleException(errorString);
            }
            if (Const.isEmpty((String)nextValueString)) {
                throw new KettleException("No value retrieved from slave sequence '" + slaveSequenceName + "' on slave " + this.toString());
            }
            long nextValue = Const.toLong((String)nextValueString, (long)Long.MIN_VALUE);
            if (nextValue == Long.MIN_VALUE) {
                throw new KettleException("Incorrect value '" + nextValueString + "' retrieved from slave sequence '" + slaveSequenceName + "' on slave " + this.toString());
            }
            return nextValue;
        }
        catch (Exception e) {
            throw new KettleException("There was a problem retrieving a next sequence value from slave sequence '" + slaveSequenceName + "' on slave " + this.toString(), (Throwable)e);
        }
    }

    public Date getChangedDate() {
        return this.changedDate;
    }
}

