/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.CarteServlet;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.www.CartePluginInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=CartePluginInterface.class)
@PluginAnnotationType(value=CarteServlet.class)
public class CartePluginType
extends BasePluginType
implements PluginTypeInterface {
    private static CartePluginType cartePluginType;

    private CartePluginType() {
        super(CarteServlet.class, "CARTE_SERVLET", "Carte Servlet");
        this.populateFolders("servlets");
    }

    public static CartePluginType getInstance() {
        if (cartePluginType == null) {
            cartePluginType = new CartePluginType();
        }
        return cartePluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String kettleServletsXmlFile = "kettle-servlets.xml";
        String alternative = System.getProperty("KETTLE_CORE_SERVLETS_FILE", null);
        if (!Const.isEmpty((String)alternative)) {
            kettleServletsXmlFile = alternative;
        }
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(kettleServletsXmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + kettleServletsXmlFile);
            }
            if (inputStream == null && !Const.isEmpty((String)alternative)) {
                try {
                    inputStream = new FileInputStream(kettleServletsXmlFile);
                }
                catch (Exception e) {
                    throw new KettlePluginException("Unable to load native servlet plugins '" + kettleServletsXmlFile + "'", (Throwable)e);
                }
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native servlets definition file: '" + kettleServletsXmlFile + "'");
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node servletsNode = XMLHandler.getSubNode((Node)document, (String)"servlets");
            List servletNodes = XMLHandler.getNodes((Node)servletsNode, (String)"servlet");
            for (Node servletNode : servletNodes) {
                this.registerPluginFromXmlResource(servletNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle servlets XML config file: '" + kettleServletsXmlFile + "'", (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading step plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((CarteServlet)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((CarteServlet)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((CarteServlet)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return "";
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((CarteServlet)annotation).isSeparateClassLoaderNeeded();
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((CarteServlet)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected String extractDocumentationUrl(Annotation annotation) {
        return null;
    }

    protected String extractCasesUrl(Annotation annotation) {
        return null;
    }

    protected String extractForumUrl(Annotation annotation) {
        return null;
    }

    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((CarteServlet)annotation).classLoaderGroup();
    }
}

