/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.repository.BaseRepositorySecurityProvider;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryConnectionDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryUserDelegate;

public class KettleDatabaseRepositorySecurityProvider
extends BaseRepositorySecurityProvider
implements RepositorySecurityProvider,
RepositorySecurityManager {
    private RepositoryCapabilities capabilities;
    private KettleDatabaseRepository repository;
    private KettleDatabaseRepositoryUserDelegate userDelegate;
    private KettleDatabaseRepositoryConnectionDelegate connectionDelegate;

    public KettleDatabaseRepositorySecurityProvider(KettleDatabaseRepository repository, RepositoryMeta repositoryMeta, IUser userInfo) {
        super(repositoryMeta, userInfo);
        this.repository = repository;
        this.capabilities = repositoryMeta.getRepositoryCapabilities();
        this.userDelegate = repository.userDelegate;
        this.connectionDelegate = repository.connectionDelegate;
    }

    @Override
    public boolean isReadOnly() {
        return this.capabilities.isReadOnly();
    }

    @Override
    public boolean isLockingPossible() {
        return this.capabilities.supportsLocking();
    }

    @Override
    public boolean allowsVersionComments() {
        return false;
    }

    @Override
    public boolean isVersionCommentMandatory() {
        return false;
    }

    @Override
    public IUser loadUserInfo(String login) throws KettleException {
        return this.userDelegate.loadUserInfo(new UserInfo(), login);
    }

    @Override
    public void saveUserInfo(IUser userInfo) throws KettleException {
        this.userDelegate.saveUserInfo(userInfo);
    }

    @Override
    public void validateAction(RepositoryOperation ... operations) throws KettleException, KettleSecurityException {
    }

    @Override
    public synchronized void delUser(ObjectId id_user) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.repository.quoteTable("R_USER") + " WHERE " + this.repository.quote("ID_USER") + " = ? ", id_user);
    }

    @Override
    public synchronized ObjectId getUserID(String login) throws KettleException {
        return this.userDelegate.getUserID(login);
    }

    @Override
    public ObjectId[] getUserIDs() throws KettleException {
        return this.connectionDelegate.getIDs("SELECT " + this.repository.quote("ID_USER") + " FROM " + this.repository.quoteTable("R_USER"), new ObjectId[0]);
    }

    @Override
    public synchronized String[] getUserLogins() throws KettleException {
        String loginField = this.repository.quote("LOGIN");
        return this.connectionDelegate.getStrings("SELECT " + loginField + " FROM " + this.repository.quoteTable("R_USER") + " ORDER BY " + loginField, new ObjectId[0]);
    }

    @Override
    public synchronized void renameUser(ObjectId id_user, String newname) throws KettleException {
        this.userDelegate.renameUser(id_user, newname);
    }

    @Override
    public void deleteUsers(List<IUser> users) throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IUser> getUsers() throws KettleException {
        String[] userLogins = this.getUserLogins();
        ArrayList<IUser> users = new ArrayList<IUser>();
        for (String userLogin : userLogins) {
            users.add(this.loadUserInfo(userLogin));
        }
        return users;
    }

    @Override
    public void setUsers(List<IUser> users) throws KettleException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delUser(String name) throws KettleException {
        this.delUser(this.getUserID(name));
    }

    @Override
    public void updateUser(IUser user) throws KettleException {
        this.userDelegate.saveUserInfo(user);
    }

    @Override
    public IUser constructUser() throws KettleException {
        return new UserInfo();
    }

    @Override
    public List<String> getAllRoles() throws KettleException {
        return null;
    }

    @Override
    public List<String> getAllUsers() throws KettleException {
        return null;
    }

    @Override
    public boolean isManaged() throws KettleException {
        return true;
    }

    @Override
    public boolean isVersioningEnabled() {
        return false;
    }
}

