/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class TransHopMeta
implements Cloneable,
XMLInterface,
Comparable<TransHopMeta> {
    private static Class<?> PKG = Trans.class;
    public static final String XML_TAG = "hop";
    private StepMeta from_step;
    private StepMeta to_step;
    private boolean enabled;
    public boolean split = false;
    private boolean changed;
    private ObjectId id;

    public TransHopMeta(StepMeta from, StepMeta to, boolean en) {
        this.from_step = from;
        this.to_step = to;
        this.enabled = en;
    }

    public TransHopMeta(StepMeta from, StepMeta to) {
        this.from_step = from;
        this.to_step = to;
        this.enabled = true;
    }

    public TransHopMeta() {
        this(null, null, false);
    }

    public TransHopMeta(Node hopnode, List<StepMeta> steps) throws KettleXMLException {
        try {
            this.from_step = this.searchStep(steps, XMLHandler.getTagValue((Node)hopnode, (String)"from"));
            this.to_step = this.searchStep(steps, XMLHandler.getTagValue((Node)hopnode, (String)"to"));
            String en = XMLHandler.getTagValue((Node)hopnode, (String)"enabled");
            this.enabled = en == null ? true : en.equalsIgnoreCase("Y");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransHopMeta.Exception.UnableToLoadHopInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setFromStep(StepMeta from) {
        this.from_step = from;
    }

    public void setToStep(StepMeta to) {
        this.to_step = to;
    }

    public StepMeta getFromStep() {
        return this.from_step;
    }

    public StepMeta getToStep() {
        return this.to_step;
    }

    private StepMeta searchStep(List<StepMeta> steps, String name) {
        for (StepMeta stepMeta : steps) {
            if (!stepMeta.getName().equalsIgnoreCase(name)) continue;
            return stepMeta;
        }
        return null;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        TransHopMeta other = (TransHopMeta)obj;
        if (this.from_step == null || this.to_step == null) {
            return false;
        }
        return this.from_step.equals(other.getFromStep()) && this.to_step.equals(other.getToStep());
    }

    @Override
    public int compareTo(TransHopMeta obj) {
        return this.toString().compareTo(obj.toString());
    }

    public ObjectId getObjectId() {
        return this.id;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setEnabled() {
        this.setEnabled(true);
    }

    public void setEnabled(boolean en) {
        this.enabled = en;
        this.setChanged();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void flip() {
        StepMeta dummy = this.from_step;
        this.from_step = this.to_step;
        this.to_step = dummy;
    }

    public String toString() {
        String str_fr = this.from_step == null ? "(empty)" : this.from_step.getName();
        String str_to = this.to_step == null ? "(empty)" : this.to_step.getName();
        return str_fr + " --> " + str_to + " (" + (this.enabled ? "enabled" : "disabled") + ")";
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        if (this.from_step != null && this.to_step != null) {
            retval.append("  <hop> ");
            retval.append(XMLHandler.addTagValue((String)"from", (String)this.from_step.getName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"to", (String)this.to_step.getName(), (boolean)false, (String[])new String[0]));
            retval.append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled, (boolean)false));
            retval.append(" </hop>");
        }
        return retval.toString();
    }
}

