/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.concatfields;

import java.io.UnsupportedEncodingException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsData;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsMeta;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsOutputStream;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;

public class ConcatFields
extends TextFileOutput
implements StepInterface {
    private static Class<?> PKG = ConcatFields.class;
    public ConcatFieldsMeta meta;
    public ConcatFieldsData data;

    public ConcatFields(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public synchronized boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (ConcatFieldsMeta)smi;
        this.data = (ConcatFieldsData)sdi;
        boolean result = true;
        boolean bEndedLineWrote = false;
        Object[] r = this.getRow();
        if (r != null && this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.inputRowMetaModified = this.getInputRowMeta().clone();
            this.meta.getFieldsModifyInput(this.data.inputRowMetaModified, this.getStepname(), null, null, this, this.repository, this.metaStore);
            this.data.posTargetField = this.data.outputRowMeta.indexOfValue(this.meta.getTargetFieldName());
            if (this.data.posTargetField < 0) {
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.TargetFieldNotFoundOutputStream", (String[])new String[]{"" + this.meta.getTargetFieldName()}));
            }
            this.data.fieldnrs = new int[this.meta.getOutputFields().length];
            for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
                this.data.fieldnrs[i] = this.data.inputRowMetaModified.indexOfValue(this.meta.getOutputFields()[i].getName());
                if (this.data.fieldnrs[i] >= 0) continue;
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.FieldNotFoundInputStream", (String[])new String[]{"" + this.meta.getOutputFields()[i].getName()}));
            }
            this.data.targetFieldLengthFastDataDump = this.meta.getTargetFieldLength();
            if (this.data.targetFieldLengthFastDataDump <= 0) {
                this.data.targetFieldLengthFastDataDump = this.meta.getOutputFields().length == 0 ? 50 * this.getInputRowMeta().size() : 50 * this.meta.getOutputFields().length;
            }
            this.prepareForReMap();
            this.checkAndWriteHeader();
        }
        if (r == null && this.data.outputRowMeta != null && this.meta.isFooterEnabled() || r != null && this.getLinesWritten() > 0L && this.meta.getSplitEvery() > 0 && (this.getLinesWritten() + 1L) % (long)this.meta.getSplitEvery() == 0L) {
            if (this.data.outputRowMeta != null && this.meta.isFooterEnabled()) {
                this.writeHeader();
                Object[] row = new Object[this.data.outputRowMeta.size()];
                this.putRowFromStream(row);
            }
            if (r == null) {
                this.writeEndedLine();
                bEndedLineWrote = true;
                this.putRowFromStream(r);
            }
        }
        if (r == null) {
            if (!bEndedLineWrote) {
                this.writeEndedLine();
                bEndedLineWrote = true;
                this.putRowFromStream(r);
            }
            this.setOutputDone();
            this.setLinesOutput(0L);
            return false;
        }
        if (!this.meta.isFastDump()) {
            this.writeRowToFile(this.data.inputRowMetaModified, r);
            this.setLinesOutput(0L);
            this.putRowFromStream(r);
        } else {
            this.putRowFastDataDump(r);
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"ConcatFields.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + this.data.outputRowMeta.getString(r));
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ConcatFields.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return result;
    }

    void checkAndWriteHeader() throws KettleStepException {
        if (!this.meta.isFileAppended() && (this.meta.isHeaderEnabled() || this.meta.isFooterEnabled()) && !this.meta.isFileNameInField() && this.meta.isHeaderEnabled() && this.data.outputRowMeta != null) {
            this.writeHeader();
            Object[] row = new Object[this.data.outputRowMeta.size()];
            this.putRowFromStream(row);
        }
    }

    void prepareForReMap() throws KettleStepException {
        if (this.meta.isRemoveSelectedFields()) {
            this.data.remainingFieldsInputOutputMapping = new int[this.data.outputRowMeta.size() - 1];
            String[] fieldNames = this.data.outputRowMeta.getFieldNames();
            for (int i = 0; i < fieldNames.length - 1; ++i) {
                this.data.remainingFieldsInputOutputMapping[i] = this.data.inputRowMetaModified.indexOfValue(fieldNames[i]);
                if (this.data.remainingFieldsInputOutputMapping[i] >= 0) continue;
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.RemainingFieldNotFoundInputStream", (String[])new String[]{"" + fieldNames[i]}));
            }
        }
    }

    void putRowFromStream(Object[] r) throws KettleStepException {
        byte[] targetBinary = ((ConcatFieldsOutputStream)this.data.writer).read();
        if (r == null && targetBinary == null) {
            return;
        }
        Object[] outputRowData = this.prepareOutputRow(r);
        if (outputRowData == null) {
            outputRowData = new Object[this.data.outputRowMeta.size()];
        }
        if (targetBinary != null) {
            if (!this.data.hasEncoding) {
                outputRowData[this.data.posTargetField] = new String(targetBinary);
            } else {
                try {
                    outputRowData[this.data.posTargetField] = new String(targetBinary, this.meta.getEncoding());
                }
                catch (UnsupportedEncodingException e) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.UnsupportedEncoding", (String[])new String[]{"" + this.meta.getEncoding()}));
                }
            }
        } else {
            outputRowData[this.data.posTargetField] = null;
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
    }

    void putRowFastDataDump(Object[] r) throws KettleStepException {
        Object[] outputRowData = this.prepareOutputRow(r);
        StringBuilder targetString = new StringBuilder(this.data.targetFieldLengthFastDataDump);
        if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
            for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
                if (i > 0) {
                    targetString.append(this.data.stringSeparator);
                }
                this.concatFieldFastDataDump(targetString, r[i], "");
            }
        } else {
            for (int i = 0; i < this.data.fieldnrs.length; ++i) {
                if (i > 0) {
                    targetString.append(this.data.stringSeparator);
                }
                this.concatFieldFastDataDump(targetString, r[this.data.fieldnrs[i]], this.data.stringNullValue[i]);
            }
        }
        outputRowData[this.data.posTargetField] = new String(targetString);
        this.putRow(this.data.outputRowMeta, outputRowData);
    }

    private void concatFieldFastDataDump(StringBuilder targetField, Object valueData, String nullString) {
        if (this.meta.isEnclosureForced()) {
            targetField.append(this.data.stringEnclosure);
        }
        if (valueData != null) {
            targetField.append(valueData);
        } else {
            targetField.append(nullString);
        }
        if (this.meta.isEnclosureForced()) {
            targetField.append(this.data.stringEnclosure);
        }
    }

    Object[] prepareOutputRow(Object[] r) {
        Object[] outputRowData = null;
        if (!this.meta.isRemoveSelectedFields()) {
            outputRowData = RowDataUtil.resizeArray((Object[])r, (int)this.data.outputRowMeta.size());
        } else {
            outputRowData = new Object[this.data.outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            if (r != null) {
                for (int i = 0; i < this.data.remainingFieldsInputOutputMapping.length; ++i) {
                    outputRowData[i] = r[this.data.remainingFieldsInputOutputMapping[i]];
                }
            }
        }
        return outputRowData;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (ConcatFieldsMeta)smi;
        this.data = (ConcatFieldsData)sdi;
        this.meta.setDoNotOpenNewFileInit(true);
        this.data.writer = new ConcatFieldsOutputStream();
        this.initStringDataFields();
        boolean rv = super.init(smi, sdi);
        this.data.binaryNewline = new byte[0];
        return rv;
    }

    private void initStringDataFields() {
        this.data.stringSeparator = "";
        this.data.stringEnclosure = "";
        if (!Const.isEmpty((String)this.meta.getSeparator())) {
            this.data.stringSeparator = this.environmentSubstitute(this.meta.getSeparator());
        }
        if (!Const.isEmpty((String)this.meta.getEnclosure())) {
            this.data.stringEnclosure = this.environmentSubstitute(this.meta.getEnclosure());
        }
        this.data.stringNullValue = new String[this.meta.getOutputFields().length];
        for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
            this.data.stringNullValue[i] = "";
            String nullString = this.meta.getOutputFields()[i].getNullString();
            if (Const.isEmpty((String)nullString)) continue;
            this.data.stringNullValue[i] = nullString;
        }
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }
}

