/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import java.util.Date;
import java.util.List;
import nl.cwi.monetdb.mcl.io.BufferedMCLReader;
import nl.cwi.monetdb.mcl.io.BufferedMCLWriter;
import nl.cwi.monetdb.mcl.net.MapiSocket;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbagilemart.MonetDBRowLimitException;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;
import org.pentaho.di.trans.steps.tableagilemart.AgileMartUtil;

public class MonetDBBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MonetDBBulkLoaderMeta.class;
    private MonetDBBulkLoaderMeta meta;
    private MonetDBBulkLoaderData data;
    private String message;
    private TransMeta localTransMeta;
    protected long rowsWritten = -1L;
    private AgileMartUtil util = new AgileMartUtil();
    private RowMetaInterface physicalTableRowMeta;

    public String getMessage() {
        return this.message;
    }

    public MonetDBBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.localTransMeta = transMeta;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected MonetDBBulkLoaderMeta getMeta() {
        return this.meta;
    }

    protected String escapeOsPath(String path, boolean isWindows) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == ' ') {
                sb.append(isWindows ? "^ " : "\\ ");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(MonetDBBulkLoaderMeta meta, boolean wait) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Started execute");
        }
        try {
            MapiSocket mserver;
            if (this.log.isDetailed()) {
                this.logDetailed("Auto String Length flag: " + meta.isAutoStringWidths());
            }
            DatabaseMeta dm = meta.getDatabaseMeta();
            String user = this.environmentSubstitute(Const.NVL((String)dm.getUsername(), (String)""));
            String password = this.environmentSubstitute(Const.NVL((String)dm.getPassword(), (String)""));
            this.data.mserver = mserver = this.getMonetDBConnection();
            this.data.in = mserver.getReader();
            this.data.out = mserver.getWriter();
            String error = this.data.in.waitForPrompt();
            if (error != null) {
                throw new KettleException("Error while connecting to MonetDB for bulk loading : " + error);
            }
            this.data.outputLogger = new StreamLogger(this.log, mserver.getInputStream(), "OUTPUT");
            if (meta.isTruncate()) {
                this.truncate();
            }
            Database db = null;
            try {
                db = new Database(meta.getParent(), dm);
                db.connect(user, password);
                this.physicalTableRowMeta = db.getTableFields(this.data.schemaTable);
            }
            catch (Exception e) {
                try {
                    this.physicalTableRowMeta = db.getTableFields(meta.getTableName());
                }
                catch (Exception e1) {
                    this.logBasic("Could not get metadata for the physical table " + this.data.schemaTable + ".");
                }
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return true;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                try {
                    this.writeBufferToMonetDB();
                    this.data.out.flush();
                }
                catch (KettleException ke) {
                    throw ke;
                }
                finally {
                    this.data.mserver.close();
                }
                this.util.updateMetadata(this.meta, this.rowsWritten);
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (int i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.execute(this.meta, true);
            }
            this.writeRowToMonetDB(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (MonetDBRowLimitException me) {
            this.logDebug(me.getMessage());
            this.stopAll();
            this.setOutputDone();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    protected void writeRowToMonetDB(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        if (this.data.bufferIndex == this.data.bufferSize || this.log.isDebug()) {
            this.writeBufferToMonetDB();
        }
        this.addRowToBuffer(rowMeta, r);
    }

    protected void addRowToBuffer(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        StringBuilder line = new StringBuilder();
        try {
            for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    line.append(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                String nullRep = new String(this.data.nullrepresentation);
                if (valueData != null) {
                    switch (valueMeta.getType()) {
                        case 2: {
                            String str = valueMeta.getString(valueData);
                            if (str == null || str.equals(nullRep)) {
                                line.append(str);
                                break;
                            }
                            line.append(this.data.quote);
                            str = str.replace("\\", "\\\\");
                            str = str.replace("\"", "\\\"");
                            if (this.meta.isAutoStringWidths()) {
                                int len = valueMeta.getLength();
                                if (len < 1) {
                                    len = 100;
                                }
                                if (str.length() > len) {
                                    str = str.substring(0, len);
                                }
                                line.append(str);
                            } else {
                                line.append(str);
                            }
                            line.append(this.data.quote);
                            break;
                        }
                        case 5: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            Long value = valueMeta.getInteger(valueData);
                            if (value == null) {
                                line.append(this.data.nullrepresentation);
                                break;
                            }
                            line.append(Long.toString(value));
                            break;
                        }
                        case 3: 
                        case 9: {
                            Date value;
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            ValueMetaInterface colMeta = null;
                            if (this.physicalTableRowMeta != null) {
                                colMeta = this.physicalTableRowMeta.getValueMeta(index);
                            }
                            if ((value = valueMeta.getDate(valueData)) == null) {
                                line.append(this.data.nullrepresentation);
                                break;
                            }
                            if (colMeta != null && colMeta.getOriginalColumnTypeName().equalsIgnoreCase("date")) {
                                line.append(this.data.monetDateMeta.getString((Object)value));
                                break;
                            }
                            if (colMeta != null && colMeta.getOriginalColumnTypeName().equalsIgnoreCase("time")) {
                                line.append(this.data.monetTimeMeta.getString((Object)value));
                                break;
                            }
                            line.append(this.data.monetTimestampMeta.getString((Object)value));
                            break;
                        }
                        case 4: {
                            Boolean value = valueMeta.getBoolean(valueData);
                            if (value == null) {
                                line.append(this.data.nullrepresentation);
                                break;
                            }
                            if (value.booleanValue()) {
                                line.append(true);
                                break;
                            }
                            line.append(false);
                            break;
                        }
                        case 1: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            Double dbl = valueMeta.getNumber(valueData);
                            if (dbl == null) {
                                line.append(this.data.nullrepresentation);
                                break;
                            }
                            line.append(Double.toString(dbl));
                            break;
                        }
                        case 6: {
                            if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatOk()[i]) {
                                line.append(valueMeta.getString(valueData));
                                break;
                            }
                            String string = valueMeta.getString(valueData);
                            if (string == null) {
                                line.append(this.data.nullrepresentation);
                                break;
                            }
                            line.append(string);
                            break;
                        }
                    }
                    continue;
                }
                line.append(this.data.nullrepresentation);
            }
            line.append(this.data.newline);
            this.data.rowBuffer[this.data.bufferIndex] = line.toString();
            ++this.data.bufferIndex;
        }
        catch (Exception e) {
            throw new KettleException("Error serializing rows of data to the MonetDB API (MAPI).", (Throwable)e);
        }
    }

    public void truncate() throws KettleException {
        String table = this.data.schemaTable;
        String truncateStatement = this.meta.getDatabaseMeta().getTruncateTableStatement(null, table);
        if (truncateStatement == null) {
            throw new KettleException("Truncate table is not supported!");
        }
        String cmd = truncateStatement + ";";
        try {
            this.executeSql(cmd);
        }
        catch (Exception e) {
            throw new KettleException("Error while truncating table " + table, (Throwable)e);
        }
        this.util.updateMetadata(this.meta, -1L);
        if (this.log.isDetailed()) {
            this.logDetailed("Successfull: " + cmd);
        }
    }

    public void drop() throws KettleException {
        try {
            this.executeSql("drop table " + this.data.schemaTable);
        }
        catch (Exception e) {
            throw new KettleException("Error while dropping table " + this.data.schemaTable, (Throwable)e);
        }
    }

    public void autoAdjustSchema(MonetDBBulkLoaderMeta meta) throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed("Attempting to auto adjust table structure");
        }
        this.drop();
        if (this.log.isDetailed()) {
            this.logDetailed("getTransMeta: " + this.getTransMeta());
        }
        if (this.log.isDetailed()) {
            this.logDetailed("getStepname: " + this.getStepname());
        }
        SQLStatement statement = meta.getTableDdl(this.getTransMeta(), this.getStepname(), true, this.data, true);
        if (this.log.isDetailed()) {
            this.logDetailed("Statement: " + statement);
        }
        if (this.log.isDetailed() && statement != null) {
            this.logDetailed("Statement has SQL: " + statement.hasSQL());
        }
        if (statement != null && statement.hasSQL()) {
            String cmd = statement.getSQL();
            try {
                this.executeSql(cmd);
            }
            catch (Exception e) {
                throw new KettleException("Error while creating table " + this.data.schemaTable, (Throwable)e);
            }
        }
        if (this.log.isDetailed()) {
            this.logDetailed("Successfull");
        }
    }

    protected void writeBufferToMonetDB() throws KettleException {
        if (this.data.bufferIndex == 0) {
            return;
        }
        try {
            StringBuffer cmdBuff = new StringBuffer();
            String nullRep = this.environmentSubstitute(this.meta.getNULLrepresentation());
            if (nullRep == null) {
                nullRep = new String(this.data.nullrepresentation);
            }
            cmdBuff.append("COPY ").append(this.data.bufferIndex).append(" RECORDS INTO ").append(this.data.schemaTable).append(" FROM STDIN USING DELIMITERS '").append(new String(this.data.separator)).append("','" + Const.CR + "','").append(new String(this.data.quote)).append("' NULL AS '" + nullRep + "';");
            String cmd = cmdBuff.toString();
            if (this.log.isDetailed()) {
                this.logDetailed(cmd);
            }
            this.data.out.write(115);
            this.data.out.write(cmdBuff.toString());
            this.data.out.newLine();
            for (int i = 0; i < this.data.bufferIndex; ++i) {
                String buffer = this.data.rowBuffer[i];
                this.data.out.write(buffer);
                if (!this.log.isRowLevel()) continue;
                this.logRowlevel(buffer);
            }
            String error = this.data.in.waitForPrompt();
            if (error != null) {
                throw new KettleException("Error loading data: " + error);
            }
            this.data.out.writeLine("");
            error = this.data.in.waitForPrompt();
            if (error != null) {
                throw new KettleException("Error loading data: " + error);
            }
            this.data.out.writeLine("");
            error = this.data.in.waitForPrompt();
            if (error != null) {
                throw new KettleException("Error loading data: " + error);
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(Const.CR);
            }
            this.data.bufferIndex = 0;
        }
        catch (Exception e) {
            throw new KettleException("An error occurred writing data to the MonetDB API (MAPI) process", (Throwable)e);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = this.environmentSubstitute(this.meta.getFieldEnclosure());
            this.data.separator = this.environmentSubstitute(this.meta.getFieldSeparator());
            String nulls = this.environmentSubstitute(this.meta.getNULLrepresentation());
            this.data.nullrepresentation = nulls == null ? new String() : nulls;
            this.data.newline = Const.CR;
            String encoding = this.environmentSubstitute(this.meta.getEncoding());
            this.data.monetDateMeta = new ValueMeta("dateMeta", 3);
            this.data.monetDateMeta.setConversionMask("yyyy/MM/dd");
            this.data.monetDateMeta.setStringEncoding(encoding);
            this.data.monetTimestampMeta = new ValueMeta("timestampMeta", 3);
            this.data.monetTimestampMeta.setConversionMask("yyyy/MM/dd HH:mm:ss");
            this.data.monetTimestampMeta.setStringEncoding(encoding);
            this.data.monetTimeMeta = new ValueMeta("timeMeta", 3);
            this.data.monetTimeMeta.setConversionMask("HH:mm:ss");
            this.data.monetTimeMeta.setStringEncoding(encoding);
            this.data.monetNumberMeta = new ValueMeta("numberMeta", 1);
            this.data.monetNumberMeta.setConversionMask("#.#");
            this.data.monetNumberMeta.setGroupingSymbol(",");
            this.data.monetNumberMeta.setDecimalSymbol(".");
            this.data.monetNumberMeta.setStringEncoding(encoding);
            this.data.bufferSize = Const.toInt((String)this.environmentSubstitute(this.meta.getBufferSize()), (int)100000);
            this.data.rowBuffer = new String[this.data.bufferSize];
            this.data.bufferIndex = 0;
            this.meta.getDatabaseMeta().setQuoteAllFields(this.meta.isFullyQuoteSQL());
            String connectionName = this.meta.getDbConnectionName();
            if (!Const.isEmpty((String)connectionName) && connectionName.startsWith("${") && connectionName.endsWith("}")) {
                this.meta.setDatabaseMeta(this.localTransMeta.findDatabase(this.environmentSubstitute(connectionName)));
            }
            this.data.schemaTable = this.meta.getDatabaseMeta(this).getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MonetDBBulkLoaderMeta)smi;
        this.data = (MonetDBBulkLoaderData)sdi;
        super.dispose(smi, sdi);
    }

    protected MonetDBBulkLoaderData getData() {
        return this.data;
    }

    protected MapiSocket getMonetDBConnection() throws Exception {
        if (this.meta == null) {
            throw new KettleException("No metadata available to determine connection information from.");
        }
        DatabaseMeta dm = this.meta.getDatabaseMeta();
        String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
        String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
        String user = this.environmentSubstitute(Const.NVL((String)dm.getUsername(), (String)""));
        String password = this.environmentSubstitute(Const.NVL((String)dm.getPassword(), (String)""));
        String db = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
        MapiSocket mserver = MonetDBBulkLoader.getMonetDBConnection(hostname, Integer.valueOf(portnum), user, password, db, this.log);
        return mserver;
    }

    protected static MapiSocket getMonetDBConnection(String host, int port, String user, String password, String db) throws Exception {
        return MonetDBBulkLoader.getMonetDBConnection(host, port, user, password, db, null);
    }

    protected static MapiSocket getMonetDBConnection(String host, int port, String user, String password, String db, LogChannelInterface log) throws Exception {
        MapiSocket mserver = new MapiSocket();
        mserver.setDatabase(db);
        mserver.setLanguage("sql");
        List warnings = mserver.connect(host, port, user, password);
        if (warnings != null) {
            for (Object warning : warnings) {
                if (log == null) continue;
                log.logBasic("MonetDB connection warning: " + warning);
            }
        } else if (log != null) {
            log.logDebug("Successful MapiSocket connection to MonetDB established.");
        }
        return mserver;
    }

    protected void executeSql(String query) throws Exception {
        if (this.meta == null) {
            throw new KettleException("No metadata available to determine connection information from.");
        }
        DatabaseMeta dm = this.meta.getDatabaseMeta();
        String hostname = this.environmentSubstitute(Const.NVL((String)dm.getHostname(), (String)""));
        String portnum = this.environmentSubstitute(Const.NVL((String)dm.getDatabasePortNumberString(), (String)""));
        String user = this.environmentSubstitute(Const.NVL((String)dm.getUsername(), (String)""));
        String password = this.environmentSubstitute(Const.NVL((String)dm.getPassword(), (String)""));
        String db = this.environmentSubstitute(Const.NVL((String)dm.getDatabaseName(), (String)""));
        MonetDBBulkLoader.executeSql(query, hostname, Integer.valueOf(portnum), user, password, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeSql(String query, String host, int port, String user, String password, String db) throws Exception {
        MapiSocket mserver = null;
        try {
            mserver = MonetDBBulkLoader.getMonetDBConnection(host, port, user, password, db);
            BufferedMCLReader in = mserver.getReader();
            BufferedMCLWriter out = mserver.getWriter();
            String error = in.waitForPrompt();
            if (error != null) {
                throw new Exception("ERROR waiting for input reader: " + error);
            }
            out.write(115);
            System.out.println(query);
            out.write(query);
            out.write(59);
            out.newLine();
            out.writeLine("");
            String line = null;
            while ((line = in.readLine()) != null) {
                int type = in.getLineType();
                if (type == 46) {
                    break;
                }
                switch (type) {
                    case 33: {
                        System.err.println(line);
                        break;
                    }
                    case 91: {
                        System.out.println(line);
                        break;
                    }
                }
            }
        }
        finally {
            if (mserver != null) {
                mserver.close();
            }
        }
    }
}

