/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.regexeval.RegexEvalData;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;

public class RegexEval
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RegexEvalMeta.class;
    private RegexEvalMeta meta;
    private RegexEvalData data;

    public RegexEval(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block24: {
            this.meta = (RegexEvalMeta)smi;
            this.data = (RegexEvalData)sdi;
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                int captureIndex = this.getInputRowMeta().size();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Const.isEmpty((String)this.environmentSubstitute(this.meta.getResultFieldName()))) {
                    if (!this.meta.isAllowCaptureGroupsFlagSet()) {
                        this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorResultFieldMissing", (String[])new String[0]));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorResultFieldMissing", (String[])new String[0]));
                    }
                    this.data.indexOfResultField = -1;
                } else {
                    if (this.meta.isReplacefields()) {
                        this.data.indexOfResultField = this.getInputRowMeta().indexOfValue(this.meta.getResultFieldName());
                    }
                    if (this.data.indexOfResultField < 0) {
                        this.data.indexOfResultField = this.getInputRowMeta().size();
                        ++captureIndex;
                    }
                }
                if (this.meta.getMatcher() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorMatcherMissing", (String[])new String[0]));
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorMatcherMissing", (String[])new String[0]));
                }
                this.data.indexOfFieldToEvaluate = this.getInputRowMeta().indexOfValue(this.meta.getMatcher());
                if (this.data.indexOfFieldToEvaluate < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getMatcher() + "]");
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.CouldnotFindField", (String[])new String[]{this.meta.getMatcher()}));
                }
                if (this.meta.isAllowCaptureGroupsFlagSet()) {
                    this.data.positions = new int[this.meta.getFieldName().length];
                    String[] fieldName = this.meta.getFieldName();
                    for (int i = 0; i < fieldName.length; ++i) {
                        if (fieldName[i] == null || fieldName[i].length() == 0) continue;
                        this.data.positions[i] = this.meta.isReplacefields() ? this.data.outputRowMeta.indexOfValue(fieldName[i]) : captureIndex++;
                    }
                } else {
                    this.data.positions = new int[0];
                }
                this.data.conversionRowMeta = this.data.outputRowMeta.cloneToType(2);
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            System.arraycopy(row, 0, outputRow, 0, this.getInputRowMeta().size());
            try {
                boolean isMatch;
                String fieldValue;
                if (this.getInputRowMeta().isNull(row, this.data.indexOfFieldToEvaluate)) {
                    fieldValue = "";
                    isMatch = false;
                } else {
                    fieldValue = this.getInputRowMeta().getString(row, this.data.indexOfFieldToEvaluate);
                    Matcher m = this.data.pattern.matcher(fieldValue);
                    isMatch = m.matches();
                    if (this.meta.isAllowCaptureGroupsFlagSet() && this.data.positions.length != m.groupCount()) {
                        this.logError(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorCaptureGroupFieldsMismatch", (String[])new String[]{String.valueOf(m.groupCount()), String.valueOf(this.data.positions.length)}));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"RegexEval.Exception.ErrorCaptureGroupFieldsMismatch", (String[])new String[]{String.valueOf(m.groupCount()), String.valueOf(this.data.positions.length)}));
                    }
                    for (int i = 0; i < this.data.positions.length; ++i) {
                        Object convertedValue;
                        int index = this.data.positions[i];
                        String value = isMatch ? m.group(i + 1) : null;
                        if (value == null) {
                            try {
                                value = this.data.outputRowMeta.getString(outputRow, index);
                            }
                            catch (ArrayIndexOutOfBoundsException err) {
                                // empty catch block
                            }
                        }
                        ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(index);
                        ValueMetaInterface conversionValueMeta = this.data.conversionRowMeta.getValueMeta(index);
                        outputRow[index] = convertedValue = valueMeta.convertDataFromString(value, conversionValueMeta, this.meta.getFieldNullIf()[i], this.meta.getFieldIfNull()[i], this.meta.getFieldTrimType()[i]);
                    }
                }
                if (this.data.indexOfResultField >= 0) {
                    outputRow[this.data.indexOfResultField] = isMatch;
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"RegexEval.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
                }
                this.putRow(this.data.outputRowMeta, outputRow);
            }
            catch (KettleException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"RegexEval.Log.ErrorInStep", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block24;
                this.putError(this.getInputRowMeta(), outputRow, 1L, errorMessage, null, "REGEX001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RegexEvalMeta)smi;
        this.data = (RegexEvalData)sdi;
        if (super.init(smi, sdi)) {
            String options = this.meta.getRegexOptions();
            String regularexpression = this.meta.getScript();
            if (this.meta.isUseVariableInterpolationFlagSet()) {
                regularexpression = this.environmentSubstitute(this.meta.getScript());
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RegexEval.Log.Regexp", (String[])new String[0]) + " " + options + regularexpression);
            }
            this.data.pattern = this.meta.isCanonicalEqualityFlagSet() ? Pattern.compile(options + regularexpression, 128) : Pattern.compile(options + regularexpression);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RegexEvalMeta)smi;
        this.data = (RegexEvalData)sdi;
        this.data.pattern = null;
        super.dispose(smi, sdi);
    }
}

