/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmlinput;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.xmlinput.XMLInputFieldPosition;
import org.pentaho.di.trans.steps.xmlinput.XMLInputMeta;
import org.w3c.dom.Node;

public class XMLInputField
implements Cloneable {
    private static Class<?> PKG = XMLInputMeta.class;
    public static final int TYPE_TRIM_NONE = 0;
    public static final int TYPE_TRIM_LEFT = 1;
    public static final int TYPE_TRIM_RIGHT = 2;
    public static final int TYPE_TRIM_BOTH = 3;
    public static final String[] trimTypeCode = new String[]{"none", "left", "right", "both"};
    public static final String[] trimTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"XMLInputField.TrimType.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputField.TrimType.Left", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputField.TrimType.Right", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputField.TrimType.Both", (String[])new String[0])};
    public static final String POSITION_MARKER = ",";
    private String name;
    private XMLInputFieldPosition[] fieldPosition;
    private int type;
    private int length;
    private String format;
    private int trimtype;
    private int precision;
    private String currencySymbol;
    private String decimalSymbol;
    private String groupSymbol;
    private boolean repeat;
    private String[] samples;

    public XMLInputField(String fieldname, XMLInputFieldPosition[] xmlInputFieldPositions) {
        this.name = fieldname;
        this.fieldPosition = xmlInputFieldPositions;
        this.length = -1;
        this.type = 2;
        this.format = "";
        this.trimtype = 0;
        this.groupSymbol = "";
        this.decimalSymbol = "";
        this.currencySymbol = "";
        this.precision = -1;
        this.repeat = false;
    }

    public XMLInputField() {
        this(null, null);
    }

    public String getXML() {
        String retval = "";
        retval = retval + "      <field>" + Const.CR;
        retval = retval + "        " + XMLHandler.addTagValue((String)"name", (String)this.getName());
        retval = retval + "        " + XMLHandler.addTagValue((String)"type", (String)this.getTypeDesc());
        retval = retval + "        " + XMLHandler.addTagValue((String)"format", (String)this.getFormat());
        retval = retval + "        " + XMLHandler.addTagValue((String)"currency", (String)this.getCurrencySymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"decimal", (String)this.getDecimalSymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"group", (String)this.getGroupSymbol());
        retval = retval + "        " + XMLHandler.addTagValue((String)"length", (int)this.getLength());
        retval = retval + "        " + XMLHandler.addTagValue((String)"precision", (int)this.getPrecision());
        retval = retval + "        " + XMLHandler.addTagValue((String)"trim_type", (String)this.getTrimTypeCode());
        retval = retval + "        " + XMLHandler.addTagValue((String)"repeat", (boolean)this.isRepeated());
        retval = retval + "        <positions>";
        for (int i = 0; i < this.fieldPosition.length; ++i) {
            retval = retval + XMLHandler.addTagValue((String)"position", (String)this.fieldPosition[i].toString(), (boolean)false, (String[])new String[0]);
        }
        retval = retval + "        </positions>" + Const.CR;
        retval = retval + "        </field>" + Const.CR;
        return retval;
    }

    public XMLInputField(Node fnode) throws KettleValueException {
        this.setName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
        this.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)"type")));
        this.setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
        this.setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
        this.setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
        this.setGroupSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
        this.setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
        this.setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
        this.setTrimType(XMLInputField.getTrimTypeByCode(XMLHandler.getTagValue((Node)fnode, (String)"trim_type")));
        this.setRepeated(!"N".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"repeat")));
        Node positions = XMLHandler.getSubNode((Node)fnode, (String)"positions");
        int nrPositions = XMLHandler.countNodes((Node)positions, (String)"position");
        this.fieldPosition = new XMLInputFieldPosition[nrPositions];
        for (int i = 0; i < nrPositions; ++i) {
            Node positionnode = XMLHandler.getSubNodeByNr((Node)positions, (String)"position", (int)i);
            String encoded = XMLHandler.getNodeValue((Node)positionnode);
            this.fieldPosition[i] = new XMLInputFieldPosition(encoded);
        }
    }

    public static final int getTrimTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeCode.length; ++i) {
            if (!trimTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final int getTrimTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < trimTypeDesc.length; ++i) {
            if (!trimTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTrimTypeCode(int i) {
        if (i < 0 || i >= trimTypeCode.length) {
            return trimTypeCode[0];
        }
        return trimTypeCode[i];
    }

    public static final String getTrimTypeDesc(int i) {
        if (i < 0 || i >= trimTypeDesc.length) {
            return trimTypeDesc[0];
        }
        return trimTypeDesc[i];
    }

    public Object clone() {
        try {
            XMLInputField retval = (XMLInputField)super.clone();
            if (this.fieldPosition != null) {
                retval.setFieldPosition(new XMLInputFieldPosition[this.fieldPosition.length]);
                for (int i = 0; i < this.fieldPosition.length; ++i) {
                    retval.getFieldPosition()[i] = (XMLInputFieldPosition)this.fieldPosition[i].clone();
                }
            }
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public XMLInputFieldPosition[] getFieldPosition() {
        return this.fieldPosition;
    }

    public void setFieldPosition(XMLInputFieldPosition[] xmlInputFieldPositions) {
        this.fieldPosition = xmlInputFieldPositions;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fieldname) {
        this.name = fieldname;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return ValueMeta.getTypeDesc((int)this.type);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setSamples(String[] samples) {
        this.samples = samples;
    }

    public String[] getSamples() {
        return this.samples;
    }

    public int getTrimType() {
        return this.trimtype;
    }

    public String getTrimTypeCode() {
        return XMLInputField.getTrimTypeCode(this.trimtype);
    }

    public String getTrimTypeDesc() {
        return XMLInputField.getTrimTypeDesc(this.trimtype);
    }

    public void setTrimType(int trimtype) {
        this.trimtype = trimtype;
    }

    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    public void setGroupSymbol(String group_symbol) {
        this.groupSymbol = group_symbol;
    }

    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    public void setDecimalSymbol(String decimal_symbol) {
        this.decimalSymbol = decimal_symbol;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currency_symbol) {
        this.currencySymbol = currency_symbol;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public boolean isRepeated() {
        return this.repeat;
    }

    public void setRepeated(boolean repeat) {
        this.repeat = repeat;
    }

    public void flipRepeated() {
        this.repeat = !this.repeat;
    }

    public String getFieldPositionsCode() {
        String enc = "";
        for (int i = 0; i < this.fieldPosition.length; ++i) {
            XMLInputFieldPosition pos = this.fieldPosition[i];
            if (i > 0) {
                enc = enc + POSITION_MARKER;
            }
            enc = enc + pos.toString();
        }
        return enc;
    }

    public void guess() {
    }

    public void setFieldPosition(String encoded) throws KettleException {
        try {
            String[] codes = encoded.split(POSITION_MARKER);
            this.fieldPosition = new XMLInputFieldPosition[codes.length];
            for (int i = 0; i < codes.length; ++i) {
                this.fieldPosition[i] = new XMLInputFieldPosition(codes[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to parse the field positions because of an error" + Const.CR + "Please use E=element or A=attribute in a comma separated list (code: " + encoded + ")", (Throwable)e);
        }
    }
}

