/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.jpivot;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pentaho.jpivot.AnalysisViewService;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IRepositoryFileData;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.UnifiedRepositoryException;
import org.pentaho.platform.api.repository2.unified.data.simple.SimpleRepositoryFileData;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.InvalidDocumentException;
import org.pentaho.platform.plugin.action.mondrian.MissingParameterException;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.xml.XmlHelper;
import org.xml.sax.EntityResolver;

public class AnalysisSaver
extends PentahoMessenger {
    private static final long serialVersionUID = 6290291421129174060L;
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_STRING = "string";
    private static final String TITLE_NODE_NAME = "title";
    public static final String SUFFIX = ".xjpivot";
    public static final String PROPERTIES_SUFFIX = ".properties";
    public static final String NEW_ACTION = "NEW_ACTION";
    private static Log logger = null;

    public Log getLogger() {
        return logger;
    }

    public static boolean saveAnalysis(IPentahoSession session, HashMap props, String path, String fileName, boolean overwrite) {
        if ("true".equals(PentahoSystem.getSystemSetting((String)"kiosk-mode", (String)"false"))) {
            throw new RuntimeException(Messages.getInstance().getErrorString("ANALYSISSAVER.ERROR_0006_SAVE_IS_DISABLED"));
        }
        try {
            logger = LogFactory.getLog(AnalysisSaver.class);
            String originalActionReference = (String)props.get("actionreference");
            if (originalActionReference == null) {
                throw new MissingParameterException(Messages.getInstance().getErrorString("ANALYSISSAVER.ERROR_0001_MISSING_ACTION_REFERENCE"));
            }
            Document document = null;
            if (NEW_ACTION.equals(originalActionReference)) {
                String model = (String)props.get("model");
                String jndi = (String)props.get("connection");
                String jdbc = null;
                String cube = null;
                String xaction = new AnalysisViewService().generateXAction(PentahoSessionHolder.getSession(), Messages.getInstance().getString("BaseTest.DEFAULT_TITLE"), Messages.getInstance().getString("BaseTest.DEFAULT_DESCRIPTION"), model, jndi, jdbc, cube);
                SAXReader reader = new SAXReader();
                reader.setEntityResolver((EntityResolver)new SolutionURIResolver());
                String encoding = XmlHelper.getEncoding((String)xaction, null);
                document = reader.read((InputStream)new ByteArrayInputStream(xaction.getBytes(encoding)));
            } else {
                try {
                    SAXReader reader = new SAXReader();
                    reader.setEntityResolver((EntityResolver)new SolutionURIResolver());
                    document = reader.read(ActionSequenceResource.getInputStream((String)originalActionReference, (Locale)LocaleHelper.getLocale()));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            document = AnalysisSaver.updateDocument(document, props);
            fileName = fileName.endsWith(SUFFIX) ? fileName : fileName + SUFFIX;
            path = AnalysisSaver.cleansePath(path, fileName);
            RepositoryFile jpivotRepoFile = null;
            IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
            try {
                jpivotRepoFile = repository.getFile(path + '/' + fileName);
            }
            catch (UnifiedRepositoryException e) {
                // empty catch block
            }
            if (jpivotRepoFile != null) {
                jpivotRepoFile = repository.updateFile(jpivotRepoFile, (IRepositoryFileData)new SimpleRepositoryFileData((InputStream)new ByteArrayInputStream(document.asXML().getBytes(document.getXMLEncoding())), LocaleHelper.getSystemEncoding(), "application/xml"), "Update to existing file");
            } else {
                RepositoryFile parentFile = repository.getFile(path);
                jpivotRepoFile = new RepositoryFile.Builder(fileName).title("default", fileName).description("default", fileName).build();
                jpivotRepoFile = repository.createFile(parentFile.getId(), jpivotRepoFile, (IRepositoryFileData)new SimpleRepositoryFileData((InputStream)new ByteArrayInputStream(document.asXML().getBytes(document.getXMLEncoding())), LocaleHelper.getSystemEncoding(), "application/xml"), "Initial JPivot View Check-in");
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getErrorString("ANALYSISSAVER.ERROR_0000_UNKNOWN"), (Throwable)e);
            return false;
        }
        return true;
    }

    private static Document updateDocument(Document document, HashMap props) {
        try {
            Element componentDefinition = null;
            Element actionOutput = null;
            Element actionSequenceOutput = null;
            Node actionSequence = document.selectSingleNode("/action-sequence");
            if (actionSequence == null) {
                throw new InvalidDocumentException(Messages.getInstance().getErrorString("ANALYSISSAVER.ERROR_0004_INVALID_ORIGIN_DOCUMENT"));
            }
            Element asElement = (Element)actionSequence;
            Node title = null;
            String propertyTitle = (String)props.get(TITLE_NODE_NAME);
            title = asElement.selectSingleNode(TITLE_NODE_NAME);
            if (title == null && propertyTitle != null) {
                title = asElement.addElement(TITLE_NODE_NAME);
            }
            if (title != null && propertyTitle != null) {
                title.setText("");
                ((Element)title).addCDATA(propertyTitle);
            }
            if ((componentDefinition = (Element)document.selectSingleNode("//action-definition[component-name='PivotViewComponent']/component-definition")) == null) {
                throw new InvalidDocumentException(Messages.getInstance().getErrorString("ANALYSISSAVER.ERROR_0005_INVALID_NO_PIVOT_ACTION"));
            }
            AnalysisSaver.updateComponent(componentDefinition, props);
            actionOutput = (Element)document.selectSingleNode("//action-definition[component-name='PivotViewComponent']/action-outputs");
            AnalysisSaver.updateOutput(actionOutput, props);
            actionSequenceOutput = (Element)document.selectSingleNode("//action-sequence/outputs");
            AnalysisSaver.updateOutput(actionSequenceOutput, props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static void updateComponent(Element componentDefinition, HashMap props) {
        for (Object key : props.keySet()) {
            Node node = componentDefinition.selectSingleNode(key.toString());
            if (node == null) {
                node = componentDefinition.addElement(key.toString());
            }
            if ("options".equals(node.getName())) {
                List optionsList = (List)props.get(key);
                Iterator optsIter = optionsList.iterator();
                while (optsIter.hasNext()) {
                    String anOption = optsIter.next().toString();
                    Node anOptionNode = node.selectSingleNode(anOption);
                    if (anOptionNode != null) continue;
                    ((Element)node).addElement(anOption);
                }
                continue;
            }
            Object value = props.get(key);
            if (value == null) continue;
            node.setText("");
            ((Element)node).addCDATA(value.toString());
        }
    }

    private static void updateOutput(Element outputNode, HashMap props) {
        for (Object key : props.keySet()) {
            Node node = outputNode.selectSingleNode(key.toString());
            if (node != null) continue;
            outputNode.addElement(key.toString()).addAttribute(ATTRIBUTE_TYPE, "options".equals(key.toString()) ? "list" : ATTRIBUTE_STRING);
        }
    }

    public static String cleansePath(String path, String fileName) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (file.getName().equals(fileName) || file.getName().equals(fileName + SUFFIX)) {
            file = file.getParentFile();
        }
        if (file == null) {
            return null;
        }
        String cleansedPath = file.getPath();
        if (File.separatorChar == '\\') {
            cleansedPath = cleansedPath.replace('\\', '/');
        }
        if (path.endsWith("/")) {
            cleansedPath = path.substring(0, path.length() - 1);
        }
        return cleansedPath;
    }
}

