/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.util.ArrayList;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.DataAccessConnectionDescriptor;
import pt.webdetails.cda.exporter.ExportOptions;
import pt.webdetails.cda.exporter.ExportedQueryResult;
import pt.webdetails.cda.exporter.ExportedTableQueryResult;
import pt.webdetails.cda.exporter.TableExporter;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.SettingsManager;
import pt.webdetails.cda.utils.DoQueryParameters;

public class CdaCoreService {
    private static Log logger = LogFactory.getLog(CdaCoreService.class);
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_START_PAGE = 0;
    private static final String JSONP_CALLBACK = "callback";
    private CdaEngine engine;
    private SettingsManager settingsManager;

    public CdaCoreService() {
        this(CdaEngine.getInstance(), CdaEngine.getInstance().getSettingsManager());
    }

    public CdaCoreService(CdaEngine engine) {
        this(engine, engine.getSettingsManager());
    }

    private CdaCoreService(CdaEngine engine, SettingsManager settingsManager) {
        this.engine = engine;
        this.settingsManager = settingsManager;
    }

    public ExportedQueryResult doQuery(DoQueryParameters parameters) throws Exception {
        String path = parameters.getPath();
        CdaSettings cdaSettings = this.settingsManager.parseSettingsFile(path);
        QueryOptions queryOptions = CdaCoreService.getQueryOptions(parameters);
        return this.engine.doExportQuery(cdaSettings, queryOptions);
    }

    public ExportedQueryResult listQueries(String cdaSettingsId, ExportOptions exportOptions) throws Exception {
        CdaSettings cda = this.settingsManager.parseSettingsFile(cdaSettingsId);
        TableModel table = this.engine.listQueries(cda);
        return this.exportQuery(table, exportOptions);
    }

    public ExportedQueryResult listParameters(String cdaSettingsId, String dataAccessId, ExportOptions exportOptions) throws Exception {
        CdaSettings cda = this.settingsManager.parseSettingsFile(cdaSettingsId);
        return this.exportQuery(this.engine.listParameters(cda, dataAccessId), exportOptions);
    }

    public String wrapQuery(DoQueryParameters parameters) throws Exception {
        return this.engine.wrapQuery(this.settingsManager.parseSettingsFile(parameters.getPath()), CdaCoreService.getQueryOptions(parameters));
    }

    public ExportedQueryResult unwrapQuery(String path, String uuid) throws Exception {
        CdaSettings cdaSettings = this.settingsManager.parseSettingsFile(path);
        QueryOptions queryOptions = this.engine.unwrapQuery(uuid);
        if (queryOptions != null) {
            return this.engine.doExportQuery(cdaSettings, queryOptions);
        }
        logger.error((Object)("unwrapQuery: uuid " + uuid + " not found."));
        return null;
    }

    public ExportedQueryResult getCdaList(ExportOptions exportOptions) throws UnsupportedExporterException {
        return this.exportQuery(this.engine.getCdaList(), exportOptions);
    }

    private ExportedQueryResult exportQuery(TableModel table, ExportOptions opts) throws UnsupportedExporterException {
        TableExporter exporter = this.engine.getExporter(opts);
        return new ExportedTableQueryResult(exporter, table);
    }

    public String listDataAccessTypes(boolean refreshCache) {
        DataAccessConnectionDescriptor[] data = this.settingsManager.getDataAccessDescriptors(refreshCache);
        StringBuilder output = new StringBuilder();
        output.append("{\n");
        for (DataAccessConnectionDescriptor datum : data) {
            output.append(datum.toJSON()).append(",\n");
        }
        output.append("\n}");
        return output.toString().replaceAll(",\n\\z", "\n");
    }

    public void clearCache() {
        CdaEngine.getInstance().getSettingsManager().clearCache();
        AbstractDataAccess.clearCache();
    }

    public static QueryOptions getQueryOptions(DoQueryParameters parameters) {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setDataAccessId(parameters.getDataAccessId());
        for (Map.Entry<String, Object> entry : parameters.getParameters().entrySet()) {
            String name = entry.getKey();
            Object parameter = entry.getValue();
            queryOptions.addParameter(name, parameter);
        }
        queryOptions.setCacheBypass(parameters.isBypassCache());
        CdaCoreService.setPostProcessOptions(parameters, queryOptions);
        CdaCoreService.setExportOptions(parameters, queryOptions);
        return queryOptions;
    }

    private static void setPostProcessOptions(DoQueryParameters parameters, QueryOptions queryOptions) {
        long pageSize = parameters.getPageSize();
        long pageStart = parameters.getPageStart();
        boolean paginate = parameters.isPaginateQuery();
        if (pageSize > 0L || pageStart > 0L || paginate) {
            if (pageSize > Integer.MAX_VALUE || pageStart > Integer.MAX_VALUE) {
                throw new ArithmeticException("Paging values too large");
            }
            queryOptions.setPaginate(true);
            queryOptions.setPageSize(pageSize > 0L ? (int)pageSize : (paginate ? 20 : 0));
            queryOptions.setPageStart(pageStart > 0L ? (int)pageStart : (paginate ? 0 : 0));
        }
        try {
            queryOptions.setOutputIndexId(parameters.getOutputIndexId());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Illegal outputIndexId '" + parameters.getOutputIndexId() + "'"));
        }
        ArrayList<String> sortBy = new ArrayList<String>();
        for (String sort : parameters.getSortBy()) {
            if (StringUtils.isEmpty((String)sort)) continue;
            sortBy.add(sort);
        }
        queryOptions.setSortBy(sortBy);
    }

    private static void setExportOptions(DoQueryParameters parameters, QueryOptions queryOptions) {
        queryOptions.setOutputType(parameters.getOutputType());
        for (Map.Entry<String, Object> entry : parameters.getExtraSettings().entrySet()) {
            String name = entry.getKey();
            Object parameter = entry.getValue();
            queryOptions.addSetting(name, (String)parameter);
        }
        if (!parameters.getJsonCallback().equals("<blank>")) {
            queryOptions.addSetting(JSONP_CALLBACK, parameters.getJsonCallback());
        }
    }
}

