/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import pt.webdetails.cda.ICdaEnvironment;
import pt.webdetails.cda.InitializationException;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.kettle.DataAccessKettleAdapter;
import pt.webdetails.cda.dataaccess.kettle.DataAccessKettleAdapterFactory;
import pt.webdetails.cda.exporter.AbstractKettleExporter;
import pt.webdetails.cda.exporter.DefaultStreamExporter;
import pt.webdetails.cda.exporter.ExportOptions;
import pt.webdetails.cda.exporter.ExportedQueryResult;
import pt.webdetails.cda.exporter.ExportedStreamQueryResult;
import pt.webdetails.cda.exporter.ExportedTableQueryResult;
import pt.webdetails.cda.exporter.ExporterEngine;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.TableExporter;
import pt.webdetails.cda.exporter.UnsupportedExporterException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.SettingsManager;
import pt.webdetails.cda.settings.UnknownDataAccessException;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IUserContentAccess;

public class CdaEngine {
    private static final Log logger = LogFactory.getLog(CdaEngine.class);
    private static CdaEngine _instance;
    private final ICdaEnvironment environment;
    private Map<UUID, QueryOptions> wrappedQueries = new ConcurrentHashMap<UUID, QueryOptions>();
    private ExporterEngine exporterEngine;
    private SettingsManager defaultSettingsManager;

    public static synchronized CdaEngine getInstance() {
        if (_instance == null) {
            throw new InitializationException("CdaEngine not initialized", null);
        }
        return _instance;
    }

    public static synchronized void init(ICdaEnvironment env) throws InitializationException {
        assert (env != null);
        _instance = new CdaEngine(env);
        ClassicEngineBoot.getInstance().start();
    }

    protected CdaEngine(ICdaEnvironment env) throws InitializationException {
        logger.info((Object)"Initializing CdaEngine");
        this.environment = env;
        this.exporterEngine = new ExporterEngine();
        this.defaultSettingsManager = new SettingsManager();
    }

    public SettingsManager getSettingsManager() {
        return this.defaultSettingsManager;
    }

    public TableExporter getExporter(ExportOptions opts) throws UnsupportedExporterException {
        return this.getExporter(opts.getOutputType(), opts.getExtraSettings());
    }

    public TableExporter getExporter(String outputType) throws UnsupportedExporterException {
        return this.getExporter(outputType, null);
    }

    public TableExporter getExporter(String outputType, Map<String, String> options) throws UnsupportedExporterException {
        return this.getExporterEngine().getExporter(outputType, options);
    }

    private ExporterEngine getExporterEngine() {
        return this.exporterEngine;
    }

    public TableModel doQuery(CdaSettings cdaSettings, QueryOptions queryOptions) throws UnknownDataAccessException, QueryException {
        DataAccess dataAccess = cdaSettings.getDataAccess(queryOptions.getDataAccessId());
        return dataAccess.doQuery(queryOptions);
    }

    public ExportedQueryResult doExportQuery(CdaSettings cdaSettings, QueryOptions queryOptions) throws QueryException, UnknownDataAccessException, UnsupportedExporterException {
        DataAccessKettleAdapter dataAccessKettleAdapter;
        DataAccess dataAccess = cdaSettings.getDataAccess(queryOptions.getDataAccessId());
        TableExporter exporter = this.getExporter(queryOptions);
        DefaultStreamExporter streamingExporter = null;
        if (!dataAccess.hasIterableParameterValues(queryOptions) && exporter instanceof AbstractKettleExporter && (dataAccessKettleAdapter = DataAccessKettleAdapterFactory.create(dataAccess, queryOptions)) != null) {
            streamingExporter = new DefaultStreamExporter((AbstractKettleExporter)exporter, dataAccessKettleAdapter);
        }
        if (streamingExporter != null) {
            return new ExportedStreamQueryResult(streamingExporter);
        }
        TableModel table = this.doQuery(cdaSettings, queryOptions);
        return new ExportedTableQueryResult(exporter, table);
    }

    public TableModel listParameters(CdaSettings cdaSettings, String dataAccessId) throws UnknownDataAccessException {
        return cdaSettings.getDataAccess(dataAccessId).listParameters();
    }

    public TableModel listQueries(CdaSettings cdaSettings) {
        return cdaSettings.listQueries();
    }

    public synchronized QueryOptions unwrapQuery(String uuid) throws UnknownDataAccessException, QueryException, UnsupportedExporterException, ExporterException {
        return this.wrappedQueries.remove(UUID.fromString(uuid));
    }

    public synchronized String wrapQuery(CdaSettings cdaSettings, QueryOptions queryOptions) {
        UUID uuid = UUID.randomUUID();
        this.wrappedQueries.put(uuid, queryOptions);
        return uuid.toString();
    }

    public TableModel getCdaList() {
        IUserContentAccess userRepo = PluginEnvironment.env().getContentAccessFactory().getUserContentAccess("/");
        List cdaFiles = userRepo.listFiles("", new IBasicFileFilter(){

            public boolean accept(IBasicFile file) {
                return StringUtils.equals((String)file.getExtension(), (String)"cda");
            }
        }, -1, false);
        int rowCount = cdaFiles.size();
        String[] colNames = new String[]{"name", "path"};
        Class[] colTypes = new Class[]{String.class, String.class};
        TypedTableModel typedTableModel = new TypedTableModel(colNames, colTypes, rowCount);
        for (IBasicFile file : cdaFiles) {
            typedTableModel.addRow(new Object[]{file.getName(), file.getFullPath()});
        }
        return typedTableModel;
    }

    private ICdaEnvironment getEnv() {
        return this.environment;
    }

    public static boolean isInitialized() {
        return _instance != null;
    }

    public static IContentAccessFactory getRepo() {
        return CdaEngine.getInstance().getEnv().getRepo();
    }

    public static ICdaEnvironment getEnvironment() {
        return CdaEngine.getInstance().getEnv();
    }

    public String getConfigProperty(String property) {
        return this.getConfig().getConfigProperty(property, null);
    }

    public String getConfigProperty(String property, String defaultValue) {
        return this.getConfig().getConfigProperty(property, defaultValue);
    }

    public Configuration getConfig() {
        return this.getEnv().getBaseConfig();
    }
}

