/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import pt.webdetails.cda.ICdaBeanFactory;

public class CoreBeanFactory
implements ICdaBeanFactory {
    private static final Log logger = LogFactory.getLog(CoreBeanFactory.class);
    protected static ConfigurableApplicationContext context;

    public CoreBeanFactory() {
        context = this.getSpringBeanFactory("cda.spring.xml");
    }

    public CoreBeanFactory(String config) {
        context = this.getSpringBeanFactory(config);
    }

    protected ConfigurableApplicationContext getSpringBeanFactory(String config) {
        logger.debug((Object)"bean factory ini");
        try {
            final ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(config);
            if (url != null) {
                logger.debug((Object)("Found spring file @ " + url));
                ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(config){

                    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
                        beanDefinitionReader.setBeanClassLoader(cl);
                    }

                    protected void prepareBeanFactory(ConfigurableListableBeanFactory clBeanFactory) {
                        super.prepareBeanFactory(clBeanFactory);
                        clBeanFactory.setBeanClassLoader(cl);
                    }

                    public ClassLoader getClassLoader() {
                        return cl;
                    }
                };
                logger.debug((Object)"bean factory context");
                return context;
            }
        }
        catch (Exception e) {
            logger.fatal((Object)"Error loading cda.spring.xml", (Throwable)e);
        }
        logger.fatal((Object)"Spring definition file does not exist. There should be a cda.spring.xml file on the classpath ");
        return null;
    }

    @Override
    public Object getBean(String id) {
        if (context.containsBean(id)) {
            return context.getBean(id);
        }
        return null;
    }

    @Override
    public String[] getBeanNamesForType(Class<?> clazz) {
        return context.getBeanNamesForType(clazz);
    }

    @Override
    public boolean containsBean(String id) {
        if (context != null) {
            return context.containsBean(id);
        }
        return false;
    }
}

