/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.CdaPropertiesHelper;
import pt.webdetails.cda.cache.ClassLoaderAwareCaller;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.cache.TableCacheKey;
import pt.webdetails.cda.cache.monitor.CacheElementInfo;
import pt.webdetails.cda.cache.monitor.ExtraCacheInfo;

public class HazelcastQueryCache
extends ClassLoaderAwareCaller
implements IQueryCache {
    private static final Log logger = LogFactory.getLog(HazelcastQueryCache.class);
    public static final String MAP_NAME = "cdaCache";
    public static final String AUX_MAP_NAME = "cdaCacheStats";
    private static final String GROUP_NAME = "cdc";
    private static HazelcastInstance hzInstance;
    private static LifecycleService lifeCycleService;
    private static long getTimeout;
    private static TimeUnit timeoutUnit;
    private static int maxTimeouts;
    private static long cacheDisablePeriod;
    private static boolean debugCache;
    private static int timeoutsReached;
    private static boolean active;

    private static IMap<TableCacheKey, TableModel> getCache() {
        return HazelcastQueryCache.getHazelcast().getMap(MAP_NAME);
    }

    private static IMap<TableCacheKey, ExtraCacheInfo> getCacheStats() {
        return HazelcastQueryCache.getHazelcast().getMap(AUX_MAP_NAME);
    }

    private static synchronized HazelcastInstance getHazelcast() {
        if (hzInstance == null || !lifeCycleService.isRunning()) {
            logger.debug((Object)"finding hazelcast instance..");
            for (HazelcastInstance instance : Hazelcast.getAllHazelcastInstances()) {
                logger.debug((Object)("found hazelcast instance [" + instance.getName() + "]"));
                if (!instance.getConfig().getGroupConfig().getName().equals(GROUP_NAME)) continue;
                logger.info((Object)("cdc hazelcast instance found: [" + instance.getName() + "]"));
                hzInstance = instance;
                lifeCycleService = hzInstance.getLifecycleService();
                break;
            }
            if (hzInstance == null) {
                logger.fatal((Object)"No valid hazelcast instance found.");
            } else {
                HazelcastQueryCache.init();
            }
        }
        return hzInstance;
    }

    public HazelcastQueryCache() {
        super(Thread.currentThread().getContextClassLoader());
    }

    private static int incrTimeouts() {
        return ++timeoutsReached;
    }

    private static int resetTimeouts() {
        timeoutsReached = 0;
        return 0;
    }

    private static void init() {
        logger.info((Object)"CDA CDC Hazelcast INIT");
        ClassLoader cdaPluginClassLoader = Thread.currentThread().getContextClassLoader();
        SyncRemoveStatsEntryListener syncRemoveStats = new SyncRemoveStatsEntryListener(cdaPluginClassLoader);
        IMap cache = hzInstance.getMap(MAP_NAME);
        cache.removeEntryListener((EntryListener)syncRemoveStats);
        cache.addEntryListener((EntryListener)syncRemoveStats, false);
        if (debugCache) {
            logger.debug((Object)"Added logging entry listener");
            cache.addEntryListener((EntryListener)new LoggingEntryListener(cdaPluginClassLoader), false);
        }
    }

    @Override
    public void shutdownIfRunning() {
    }

    @Override
    public void putTableModel(TableCacheKey key, TableModel table, int ttlSec, ExtraCacheInfo info) {
        HazelcastQueryCache.getCache().putAsync((Object)key, (Object)table);
        info.setEntryTime(System.currentTimeMillis());
        info.setTimeToLive(ttlSec * 1000);
        HazelcastQueryCache.getCacheStats().putAsync((Object)key, (Object)info);
    }

    private <K, V> V getWithTimeout(K key, IMap<K, V> map) {
        if (!active) {
            return null;
        }
        Future future = map.getAsync(key);
        try {
            Object result = future.get(getTimeout, timeoutUnit);
            HazelcastQueryCache.resetTimeouts();
            return result;
        }
        catch (TimeoutException e) {
            int nbrTimeouts = HazelcastQueryCache.incrTimeouts();
            this.checkNbrTimeouts(nbrTimeouts);
            logger.error((Object)("Timeout " + getTimeout + " " + (Object)((Object)timeoutUnit) + " expired fetching from " + map.getName() + " (timeout#" + nbrTimeouts + ")"));
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
        return null;
    }

    private void checkNbrTimeouts(int nbrTimeouts) {
        if (nbrTimeouts > 0 && nbrTimeouts % maxTimeouts == 0) {
            logger.error((Object)("Too many timeouts, disabling for " + cacheDisablePeriod + " seconds."));
            HazelcastQueryCache.resetTimeouts();
            active = false;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(cacheDisablePeriod * 1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    active = true;
                }
            }).start();
        }
    }

    @Override
    public TableModel getTableModel(TableCacheKey key) {
        try {
            ExtraCacheInfo info = this.getWithTimeout(key, HazelcastQueryCache.getCacheStats());
            if (info != null) {
                if (info.getTimeToLive() > 0 && (long)info.getTimeToLive() + info.getEntryTime() < System.currentTimeMillis()) {
                    logger.info((Object)"Cache element expired, removing from cache.");
                    HazelcastQueryCache.getCache().removeAsync((Object)key);
                    return null;
                }
                TableModel tm = this.getWithTimeout(key, HazelcastQueryCache.getCache());
                if (tm == null) {
                    logger.error((Object)"Cache stats out of sync! Removing element.");
                    HazelcastQueryCache.getCacheStats().removeAsync((Object)key);
                    return null;
                }
                logger.info((Object)"Table found in cache. Returning.");
                return tm;
            }
            return null;
        }
        catch (ClassCastException e) {
            Object obj = HazelcastQueryCache.getCache().get((Object)key);
            logger.error((Object)("Expected TableModel in cache, found " + obj.getClass().getCanonicalName() + " instead."));
            if (obj instanceof DataRecordEntry) {
                DataRecordEntry drEntry = (DataRecordEntry)obj;
                logger.info((Object)"Cache holding DataRecordEntry, attempting recovery");
                Object val = drEntry.getValue();
                if (val instanceof TableModel) {
                    TableModel tm = (TableModel)val;
                    logger.warn((Object)"TableModel found in record, attempting to replace cache entry..");
                    HazelcastQueryCache.getCache().replace((Object)key, (Object)tm);
                    logger.info((Object)"Cache entry replaced.");
                    return tm;
                }
                logger.error((Object)("DataRecordEntry in cache has value of unexpected type " + obj.getClass().getCanonicalName()));
                logger.warn((Object)"Removing incompatible cache entry.");
                HazelcastQueryCache.getCache().remove((Object)key);
            }
            return null;
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                logger.error((Object)("IO error while attempting to get key " + key + "(" + e.getCause().getMessage() + "), removing from cache!"), (Throwable)e);
                HazelcastQueryCache.getCache().removeAsync((Object)key);
                return null;
            }
            logger.error((Object)"Unexpected exception ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void clearCache() {
        HazelcastQueryCache.getCache().clear();
        HazelcastQueryCache.getCacheStats().clear();
    }

    @Override
    public boolean remove(TableCacheKey key) {
        return HazelcastQueryCache.getCache().remove((Object)key) != null;
    }

    @Override
    public Iterable<TableCacheKey> getKeys() {
        return HazelcastQueryCache.getCache().keySet();
    }

    public Iterable<TableCacheKey> getKeys(String cdaSettingsId, String dataAccessId) {
        return HazelcastQueryCache.getCacheStats().keySet((Predicate)new SqlPredicate("cdaSettingsId = " + cdaSettingsId + " AND dataAccessId = " + dataAccessId));
    }

    @Override
    public ExtraCacheInfo getCacheEntryInfo(TableCacheKey key) {
        return (ExtraCacheInfo)HazelcastQueryCache.getCacheStats().get((Object)key);
    }

    @Override
    public int removeAll(final String cdaSettingsId, final String dataAccessId) {
        if (cdaSettingsId == null) {
            int size = HazelcastQueryCache.getCache().size();
            HazelcastQueryCache.getCache().clear();
            return size;
        }
        try {
            return this.callInClassLoader(new Callable<Integer>(){

                @Override
                public Integer call() {
                    int size = 0;
                    Iterable<Map.Entry<TableCacheKey, ExtraCacheInfo>> entries = HazelcastQueryCache.this.getCacheStatsEntries(cdaSettingsId, dataAccessId);
                    if (entries != null) {
                        for (Map.Entry<TableCacheKey, ExtraCacheInfo> entry : entries) {
                            HazelcastQueryCache.getCache().remove((Object)entry.getKey());
                            ++size;
                        }
                    }
                    return size;
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"Error calling removeAll", (Throwable)e);
            return -1;
        }
    }

    @Override
    public CacheElementInfo getElementInfo(TableCacheKey key) {
        ExtraCacheInfo info = (ExtraCacheInfo)HazelcastQueryCache.getCacheStats().get((Object)key);
        MapEntry entry = HazelcastQueryCache.getCache().getMapEntry((Object)key);
        long NO_DATE = 0L;
        CacheElementInfo ceInfo = new CacheElementInfo();
        long creationTime = entry.getCreationTime();
        ceInfo.setAccessTime(entry.getLastAccessTime());
        if (ceInfo.getAccessTime() == 0L) {
            ceInfo.setAccessTime(creationTime);
        }
        ceInfo.setByteSize(entry.getCost());
        ceInfo.setInsertTime(entry.getLastUpdateTime());
        if (ceInfo.getInsertTime() == 0L) {
            ceInfo.setInsertTime(creationTime);
        }
        ceInfo.setKey(key);
        ceInfo.setHits(entry.getHits());
        ceInfo.setRows(info.getNbrRows());
        ceInfo.setDuration(info.getQueryDurationMs());
        return ceInfo;
    }

    public Iterable<Map.Entry<TableCacheKey, ExtraCacheInfo>> getCacheStatsEntries(String cdaSettingsId, String dataAccessId) {
        ArrayList<Map.Entry<TableCacheKey, ExtraCacheInfo>> result = new ArrayList<Map.Entry<TableCacheKey, ExtraCacheInfo>>();
        for (Map.Entry entry : HazelcastQueryCache.getCacheStats().entrySet()) {
            if (!((ExtraCacheInfo)entry.getValue()).getCdaSettingsId().equals(cdaSettingsId) || dataAccessId != null && !dataAccessId.equals(((ExtraCacheInfo)entry.getValue()).getDataAccessId())) continue;
            result.add(entry);
        }
        return result;
    }

    static {
        getTimeout = CdaPropertiesHelper.getIntProperty("pt.webdetails.cda.cache.getTimeout", 5);
        timeoutUnit = TimeUnit.SECONDS;
        maxTimeouts = CdaPropertiesHelper.getIntProperty("pt.webdetails.cda.cache.maxTimeouts", 4);
        cacheDisablePeriod = CdaPropertiesHelper.getIntProperty("pt.webdetails.cda.cache.disablePeriod", 5);
        debugCache = CdaPropertiesHelper.getBoolProperty("pt.webdetails.cda.cache.debug", true);
        timeoutsReached = 0;
        active = true;
    }

    static class LoggingEntryListener
    extends ClassLoaderAwareCaller
    implements EntryListener<TableCacheKey, TableModel> {
        private static final Log logger = LogFactory.getLog(HazelcastQueryCache.class);

        public LoggingEntryListener(ClassLoader classLoader) {
            super(classLoader);
        }

        public void entryAdded(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("CDA ENTRY ADDED " + event));
                }
            });
        }

        public void entryRemoved(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("CDA ENTRY REMOVED " + event));
                }
            });
        }

        public void entryUpdated(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("CDA ENTRY UPDATED " + event));
                }
            });
        }

        public void entryEvicted(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)("CDA ENTRY EVICTED " + event));
                }
            });
        }
    }

    private static final class SyncRemoveStatsEntryListener
    extends ClassLoaderAwareCaller
    implements EntryListener<TableCacheKey, TableModel> {
        public SyncRemoveStatsEntryListener(ClassLoader classLoader) {
            super(classLoader);
        }

        public void entryAdded(EntryEvent<TableCacheKey, TableModel> event) {
        }

        public void entryUpdated(EntryEvent<TableCacheKey, TableModel> event) {
        }

        public void entryRemoved(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    TableCacheKey key = (TableCacheKey)event.getKey();
                    logger.debug((Object)("entry removed, removing stats for query " + key));
                    HazelcastQueryCache.getCacheStats().remove((Object)key);
                }
            });
        }

        public void entryEvicted(final EntryEvent<TableCacheKey, TableModel> event) {
            this.runInClassLoader(new Runnable(){

                @Override
                public void run() {
                    TableCacheKey key = (TableCacheKey)event.getKey();
                    logger.debug((Object)("entry evicted, removing stats for query " + key));
                    HazelcastQueryCache.getCacheStats().remove((Object)key);
                }
            });
        }

        public boolean equals(Object other) {
            return other instanceof SyncRemoveStatsEntryListener;
        }
    }
}

