/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.dataaccess.Parameter;

public class TableCacheKey
implements Serializable {
    private static final long serialVersionUID = 5L;
    private int connectionHash;
    private String query;
    private String queryType;
    private Parameter[] parameters;
    private Serializable extraCacheKey;

    protected TableCacheKey() {
    }

    public TableCacheKey(Connection connection, String query, List<Parameter> parameters, Serializable extraCacheKey) {
        if (connection == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.connectionHash = connection.hashCode();
        this.query = query;
        this.parameters = parameters.toArray(new Parameter[parameters.size()]);
        TableCacheKey.sortParameters(this.parameters);
        this.extraCacheKey = extraCacheKey;
    }

    public TableCacheKey(Connection connection, String query, String queryType, List<Parameter> parameters, Serializable extraCacheKey) {
        if (connection == null) {
            throw new NullPointerException();
        }
        if (query == null) {
            throw new NullPointerException();
        }
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.connectionHash = connection.hashCode();
        this.query = query;
        this.queryType = queryType;
        this.parameters = parameters.toArray(new Parameter[parameters.size()]);
        TableCacheKey.sortParameters(this.parameters);
        this.extraCacheKey = extraCacheKey;
    }

    public int getConnectionHash() {
        return this.connectionHash;
    }

    public void setConnectionHash(int connectionHash) {
        this.connectionHash = connectionHash;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameterDataRow(ParameterDataRow parameterDataRow) {
        this.parameters = TableCacheKey.createParametersFromParameterDataRow(parameterDataRow);
    }

    public Object getExtraCacheKey() {
        return this.extraCacheKey;
    }

    public void setExtraCacheKey(Serializable extraCacheKey) {
        this.extraCacheKey = extraCacheKey;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.connectionHash = in.readInt();
        this.query = (String)in.readObject();
        this.queryType = (String)in.readObject();
        int len = in.readInt();
        Parameter[] params = new Parameter[len];
        for (int i = 0; i < params.length; ++i) {
            Parameter param = new Parameter();
            param.readObject(in);
            params[i] = param;
        }
        this.parameters = params;
        this.extraCacheKey = (Serializable)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.connectionHash);
        out.writeObject(this.query);
        out.writeObject(this.queryType);
        out.writeInt(this.parameters.length);
        for (Parameter param : this.parameters) {
            param.writeObject(out);
        }
        out.writeObject(this.extraCacheKey);
    }

    public static String getTableCacheKeyAsString(TableCacheKey cacheKey) throws IOException, UnsupportedEncodingException {
        ByteArrayOutputStream keyStream = new ByteArrayOutputStream();
        ObjectOutputStream objStream = new ObjectOutputStream(keyStream);
        cacheKey.writeObject(objStream);
        String identifier = new String(Base64.encodeBase64((byte[])keyStream.toByteArray()), "UTF-8");
        return identifier;
    }

    public static TableCacheKey getTableCacheKeyFromString(String encodedCacheKey) throws IOException, ClassNotFoundException {
        ByteArrayInputStream keyStream = new ByteArrayInputStream(Base64.decodeBase64((byte[])encodedCacheKey.getBytes()));
        ObjectInputStream objStream = new ObjectInputStream(keyStream);
        TableCacheKey cacheKey = new TableCacheKey();
        cacheKey.readObject(objStream);
        return cacheKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableCacheKey that = (TableCacheKey)o;
        if (this.connectionHash != that.connectionHash) {
            return false;
        }
        if (this.parameters != null ? !Arrays.equals(this.parameters, that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        return !(this.extraCacheKey != null ? !this.extraCacheKey.equals(that.extraCacheKey) : that.extraCacheKey != null);
    }

    public int hashCode() {
        int result = this.connectionHash;
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        result = 31 * result + (this.queryType != null ? this.queryType.hashCode() : 0);
        result = 31 * result + (this.parameters != null ? Arrays.hashCode(this.parameters) : 0);
        result = 31 * result + (this.extraCacheKey != null ? this.extraCacheKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return TableCacheKey.class.getName() + " [" + this.hashCode() + "]\n" + "\tConnectionHash:[" + this.getConnectionHash() + "]\n" + "\tQuery:[" + this.getQuery() + "]\n" + "\tQueryType:[" + this.getQueryType() + "]\n" + "\tParameters: [" + StringUtils.join((Object[])this.getParameters(), (String)", ") + "]\n" + "\tExtra: [" + this.getExtraCacheKey() + "]\n";
    }

    private static void sortParameters(Parameter[] params) {
        Arrays.sort(params, new Comparator<Parameter>(){

            @Override
            public int compare(Parameter o1, Parameter o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private static Parameter[] createParametersFromParameterDataRow(ParameterDataRow row) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (row != null) {
            String[] arr$ = row.getColumnNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name;
                Object value = row.get(name = arr$[i$]);
                Parameter param = new Parameter(name, value != null ? value : null);
                Parameter.Type type = Parameter.Type.inferTypeFromObject(value);
                param.setType(type);
                parameters.add(param);
            }
        }
        Parameter[] params = parameters.toArray(new Parameter[parameters.size()]);
        TableCacheKey.sortParameters(params);
        return params;
    }
}

