/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.cache.monitor;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.cache.TableCacheKey;
import pt.webdetails.cda.dataaccess.Parameter;

public class CacheElementInfo {
    TableCacheKey key;
    Integer rows;
    long insertTime;
    long accessTime;
    long hits;
    Long byteSize;
    Long duration;
    int timeToLive;

    public TableCacheKey getKey() {
        return this.key;
    }

    public void setKey(TableCacheKey key) {
        this.key = key;
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public long getInsertTime() {
        return this.insertTime;
    }

    public void setInsertTime(long insertTime) {
        this.insertTime = insertTime;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public void setAccessTime(long accessTime) {
        this.accessTime = accessTime;
    }

    public long getHits() {
        return this.hits;
    }

    public void setHits(long hits) {
        this.hits = hits;
    }

    public Long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(Long byteSize) {
        this.byteSize = byteSize;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public JSONObject toJson() throws JSONException, IOException {
        JSONObject queryInfo = new JSONObject();
        queryInfo.put("query", (Object)this.key.getQuery());
        JSONObject parameters = new JSONObject();
        for (Parameter param : this.key.getParameters()) {
            parameters.put(param.getName(), (Object)param.getStringValue());
        }
        queryInfo.put("parameters", (Object)parameters);
        queryInfo.put("rows", this.rows != null ? Integer.valueOf(this.rows) : null);
        queryInfo.put("inserted", this.insertTime);
        queryInfo.put("accessed", this.accessTime);
        queryInfo.put("hits", this.hits);
        queryInfo.put("size", this.byteSize != null ? Long.valueOf(this.byteSize) : null);
        if (this.duration != null) {
            queryInfo.put("duration", this.duration.longValue());
        }
        queryInfo.put("timeToLive", this.timeToLive);
        String identifier = TableCacheKey.getTableCacheKeyAsString(this.key);
        queryInfo.put("key", (Object)identifier);
        return queryInfo;
    }

    public String toString() {
        try {
            return this.toJson().toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

