/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.ConnectionInfo;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;

public class ConnectionCatalog {
    private static final String CONN_PATH = "resources/components/connections";
    private static ConnectionCatalog _instance;
    private static Log logger;
    private HashMap<String, ConnectionInfo> connectionPool;

    public ConnectionCatalog() {
        this.getConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnections() {
        this.connectionPool = new HashMap();
        IReadAccess connectionsReader = CdaEngine.getRepo().getPluginSystemReader(CONN_PATH);
        List files = connectionsReader.listFiles("", RepositoryHelper.getSimpleExtensionFilter((String)"xml"));
        if (files != null && files.size() > 0) {
            for (IBasicFile file : files) {
                InputStream in = null;
                try {
                    Connection connection;
                    in = file.getContents();
                    SAXReader reader = new SAXReader();
                    Document doc = reader.read(in);
                    Node implementation = doc.selectSingleNode("/Connection/Implementation");
                    Node type = doc.selectSingleNode("/Connection/Type");
                    String className = implementation.getText();
                    if (className == null || (connection = this.connectionFromClass(className)) == null) continue;
                    String connectionType = type.getText();
                    ConnectionType ct = ConnectionType.valueOf(connectionType);
                    this.connectionPool.put(connection.getClass().toString(), new ConnectionInfo(ct, connection.getClass()));
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
    }

    public Connection[] getConnectionsByType(ConnectionType type) {
        ArrayList<Connection> conns = new ArrayList<Connection>();
        for (String key : this.connectionPool.keySet()) {
            ConnectionInfo conn = this.connectionPool.get(key);
            if (conn.getType() != type) continue;
            try {
                conns.add(conn.getImplementation().getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception ex) {
                logger.error((Object)("Couldn't instantiate " + conn.toString()));
            }
        }
        return conns.toArray(new Connection[conns.size()]);
    }

    private Connection connectionFromClass(String className) {
        Connection connection = null;
        try {
            Class<?> cClass = Class.forName(className);
            if (!cClass.isInterface() && Connection.class.isAssignableFrom(cClass)) {
                connection = (Connection)cClass.newInstance();
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return connection;
    }

    public static synchronized ConnectionCatalog getInstance(boolean refreshCache) {
        if (_instance == null || refreshCache) {
            _instance = new ConnectionCatalog();
        }
        return _instance;
    }

    static {
        logger = LogFactory.getLog(ConnectionCatalog.class);
    }

    public static enum ConnectionType {
        SQL,
        MQL,
        MDX,
        OLAP4J,
        SCRIPTING,
        NONE,
        XPATH,
        KETTLE;

    }
}

