/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.mondrian;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.mondrian.AbstractMondrianConnection;
import pt.webdetails.cda.connections.mondrian.JdbcConnectionInfo;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;

public class JdbcConnection
extends AbstractMondrianConnection {
    private static final Log logger = LogFactory.getLog(JdbcConnection.class);
    public static final String TYPE = "mondrianJdbc";
    private JdbcConnectionInfo connectionInfo;
    private Element connection;

    public JdbcConnection(Element connection) throws InvalidConnectionException {
        super(connection);
        this.connection = connection;
    }

    public JdbcConnection() {
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new JdbcConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DataSourceProvider getInitializedDataSourceProvider() throws InvalidConnectionException {
        logger.debug((Object)"Creating new jdbc connection");
        DriverDataSourceProvider connectionProvider = new DriverDataSourceProvider();
        connectionProvider.setDriver(this.connectionInfo.getDriver());
        connectionProvider.setUrl(this.connectionInfo.getUrl());
        Properties properties = this.connectionInfo.getProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            connectionProvider.setProperty(key, value);
        }
        return connectionProvider;
    }

    @Override
    public synchronized JdbcConnectionInfo getConnectionInfo() {
        JdbcConnectionInfo ci = new JdbcConnectionInfo(this.connection);
        ci.setMondrianRole(this.assembleRole(ci.getCatalog()));
        return ci;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcConnection that = (JdbcConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }

    @Override
    public ArrayList<PropertyDescriptor> getProperties() {
        List properties = super.getProperties();
        ((ArrayList)properties).add(new PropertyDescriptor("driver", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("url", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("user", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("pass", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }
}

