/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.connections.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DriverConnectionProvider;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.sql.AbstractSqlConnection;
import pt.webdetails.cda.connections.sql.JdbcConnectionInfo;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.utils.Util;

public class JdbcConnection
extends AbstractSqlConnection {
    private static final Log logger = LogFactory.getLog(JdbcConnection.class);
    public static final String TYPE = "sqlJdbc";
    private JdbcConnectionInfo connectionInfo;

    public JdbcConnection(Element connection) throws InvalidConnectionException {
        super(connection);
    }

    public JdbcConnection() {
    }

    @Override
    protected void initializeConnection(Element connection) throws InvalidConnectionException {
        this.connectionInfo = new JdbcConnectionInfo(connection);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ConnectionProvider getInitializedConnectionProvider() throws InvalidConnectionException {
        logger.debug((Object)"Creating new jdbc connection");
        DriverConnectionProvider connectionProvider = new DriverConnectionProvider();
        connectionProvider.setDriver(this.connectionInfo.getDriver());
        connectionProvider.setUrl(this.connectionInfo.getUrl());
        Properties properties = this.connectionInfo.getProperties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            connectionProvider.setProperty(key, value);
        }
        logger.debug((Object)"Opening connection");
        try {
            Connection connection = connectionProvider.createConnection(this.connectionInfo.getUser(), this.connectionInfo.getPass());
            connection.close();
        }
        catch (SQLException e) {
            throw new InvalidConnectionException("JdbcConnection: Found SQLException: " + Util.getExceptionDescription(e), e);
        }
        logger.debug((Object)"Connection opened");
        return connectionProvider;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcConnection that = (JdbcConnection)o;
        return !(this.connectionInfo != null ? !this.connectionInfo.equals(that.connectionInfo) : that.connectionInfo != null);
    }

    @Override
    public int hashCode() {
        return this.connectionInfo != null ? this.connectionInfo.hashCode() : 0;
    }

    @Override
    public ArrayList<PropertyDescriptor> getProperties() {
        List properties = super.getProperties();
        ((ArrayList)properties).add(new PropertyDescriptor("driver", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("url", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("user", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        ((ArrayList)properties).add(new PropertyDescriptor("pass", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public String getPasswordField() {
        return this.connectionInfo.getPasswordField();
    }

    @Override
    public String getUserField() {
        return this.connectionInfo.getUserField();
    }

    public JdbcConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }
}

