/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.BandedMDXDataFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.mondrian.MondrianConnection;
import pt.webdetails.cda.connections.mondrian.MondrianConnectionInfo;
import pt.webdetails.cda.dataaccess.ICubeFileProviderSetter;
import pt.webdetails.cda.dataaccess.IDataAccessUtils;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.SimpleDataAccess;
import pt.webdetails.cda.settings.UnknownConnectionException;

public class GlobalMdxDataAccess
extends PREDataAccess {
    private static final Log logger = LogFactory.getLog(GlobalMdxDataAccess.class);

    public GlobalMdxDataAccess(String id, String name, String connectionId, String query) {
        super(id, name, connectionId, query);
    }

    public GlobalMdxDataAccess(Element element) {
        super(element);
    }

    public GlobalMdxDataAccess() {
    }

    protected AbstractNamedMDXDataFactory createDataFactory() {
        return new BandedMDXDataFactory();
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        logger.debug((Object)"Creating MDXDataFactory");
        MondrianConnection connection = (MondrianConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        MondrianConnectionInfo mondrianConnectionInfo = connection.getConnectionInfo();
        AbstractNamedMDXDataFactory mdxDataFactory = this.createDataFactory();
        IDataAccessUtils dataAccessUtils = CdaEngine.getEnvironment().getDataAccessUtils();
        dataAccessUtils.setMdxDataFactoryBaseConnectionProperties(connection, mdxDataFactory);
        mdxDataFactory.setDataSourceProvider(connection.getInitializedDataSourceProvider());
        mdxDataFactory.setJdbcPassword(mondrianConnectionInfo.getPass());
        mdxDataFactory.setJdbcUser(mondrianConnectionInfo.getUser());
        mdxDataFactory.setRole(mondrianConnectionInfo.getMondrianRole());
        mdxDataFactory.setRoleField(mondrianConnectionInfo.getRoleField());
        mdxDataFactory.setJdbcPasswordField(mondrianConnectionInfo.getPasswordField());
        mdxDataFactory.setJdbcUserField(mondrianConnectionInfo.getUserField());
        Properties baseProperties = mdxDataFactory.getBaseConnectionProperties();
        String dynamicSchemaProcessor = this.cleanQuotes(baseProperties.getProperty("DynamicSchemaProcessor"));
        String useContentChecksum = this.cleanQuotes(baseProperties.getProperty("UseContentChecksum"));
        if (dynamicSchemaProcessor != null) {
            mdxDataFactory.setDynamicSchemaProcessor(dynamicSchemaProcessor);
        }
        if (useContentChecksum != null) {
            mdxDataFactory.setUseContentChecksum(Boolean.valueOf(Boolean.parseBoolean(useContentChecksum)));
        }
        ICubeFileProviderSetter cubeFileProviderSetter = CdaEngine.getEnvironment().getCubeFileProviderSetter();
        cubeFileProviderSetter.setCubeFileProvider(mdxDataFactory, mondrianConnectionInfo.getCatalog());
        mdxDataFactory.setQuery("query", this.getQuery());
        return mdxDataFactory;
    }

    @Override
    public String getType() {
        return "";
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.MDX;
    }

    @Override
    protected SimpleDataAccess.IDataSourceQuery performRawQuery(ParameterDataRow parameterDataRow) throws QueryException {
        String MDX_MULTI_SEPARATOR = ",";
        String[] columnNames = parameterDataRow.getColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String colName = columnNames[i];
            Object value = parameterDataRow.get(colName);
            if (value != null && value.getClass().isArray()) {
                value = StringUtils.join((Object[])((Object[])value), (String)",");
            }
            values[i] = value;
        }
        return super.performRawQuery(new ParameterDataRow(columnNames, values));
    }

    private String cleanQuotes(String str) {
        if (str != null && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }
}

