/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.Serializable;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.kettle.KettleConnection;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.UnknownConnectionException;

public class KettleDataAccess
extends PREDataAccess {
    private String path;

    public KettleDataAccess(Element element) {
        super(element);
    }

    public KettleDataAccess() {
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        KettleConnection connection = (KettleConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        KettleDataFactory dataFactory = new KettleDataFactory();
        dataFactory.setQuery("query", connection.createTransformationProducer(this.getQuery(), this.getCdaSettings()));
        return dataFactory;
    }

    @Override
    public String getType() {
        return "kettle";
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.KETTLE;
    }

    @Override
    public void setCdaSettings(CdaSettings cdaSettings) {
        super.setCdaSettings(cdaSettings);
        ResourceManager resourceManager = CdaEngine.getInstance().getSettingsManager().getResourceManager();
        try {
            ResourceKey fileKey = resourceManager.deriveKey(this.getCdaSettings().getContextKey(), "");
            this.path = fileKey.getIdentifierAsString();
        }
        catch (ResourceKeyCreationException e) {
            this.path = null;
        }
    }

    @Override
    public Serializable getExtraCacheKey() {
        CacheKey cacheKey = this.getCacheKey() != null ? ((CacheKey)this.getCacheKey()).clone() : new CacheKey();
        cacheKey.addKeyValuePair("path", this.path);
        return cacheKey;
    }
}

