/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import pt.webdetails.cda.dataaccess.InvalidParameterException;
import pt.webdetails.cda.utils.FormulaEvaluator;
import pt.webdetails.cda.utils.Util;
import pt.webdetails.cda.xml.DomVisitor;

public class Parameter
implements Serializable {
    static Log logger = LogFactory.getLog(Parameter.class);
    private static final long serialVersionUID = 3L;
    static final String DEFAULT_ARRAY_SEPERATOR = ";";
    private String name;
    private Type type;
    private Object defaultValue;
    private String pattern = "";
    private Object value;
    private Access access = Access.PUBLIC;
    private String separator = ";";
    private static final String FORMULA_BEGIN = "${";
    private static final String FORMULA_END = "}";

    public Parameter() {
    }

    public Parameter(String name, String type, String defaultValue, String pattern, String access) {
        this.name = name;
        this.type = Type.parse(type);
        this.defaultValue = defaultValue;
        this.pattern = pattern;
        this.access = Access.parse(access);
    }

    public Parameter(Parameter param) {
        this(param.getName(), param.getTypeAsString(), param.getStringValue(), param.getPattern(), param.getAccess().toString());
        this.setSeparator(param.getSeparator());
    }

    public Parameter(Element p) {
        this(p.attributeValue("name"), p.attributeValue("type"), p.attributeValue("default"), p.attributeValue("pattern"), p.attributeValue("access"));
        this.setSeparator(p.attributeValue("separator"));
    }

    public Parameter(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public void inheritDefaults(Parameter defaultParameter) {
        if (this.type == null) {
            this.setType(defaultParameter.getType());
        }
        if (this.type == Type.DATE || this.type == Type.DATE_ARRAY) {
            this.setPattern(defaultParameter.getPattern());
        }
        this.setSeparator(defaultParameter.getSeparator());
    }

    public Object getValue() throws InvalidParameterException {
        Object objValue;
        Object object = objValue = this.value == null ? this.getDefaultValue() : this.value;
        if (objValue instanceof Object[] && Type.INTEGER_ARRAY.equals((Object)this.getType()) || Type.NUMERIC_ARRAY.equals((Object)this.getType())) {
            ArrayList<String> parsed = new ArrayList<String>();
            for (Object obj : (Object[])objValue) {
                parsed.add(obj.toString());
            }
            objValue = this.stringArrayToString(parsed.toArray(new String[parsed.size()]), this.getSeparator());
        }
        if (objValue instanceof String) {
            String strValue = (String)objValue;
            if (strValue != null && strValue.trim().startsWith(FORMULA_BEGIN)) {
                String formula = Util.getContentsBetween(strValue, FORMULA_BEGIN, FORMULA_END);
                if (formula == null) {
                    throw new InvalidParameterException("Malformed formula expression", null);
                }
                Object value = FormulaEvaluator.processFormula(formula);
                if (this.getType() == Type.STRING && !(value instanceof String)) {
                    return this.getValueAsString(value);
                }
                return value;
            }
            Type valueType = this.getType();
            if (valueType == null) {
                throw new InvalidParameterException("Parameter type " + (Object)((Object)this.getType()) + " unknown, can't continue", null);
            }
            this.value = this.getValueFromString(strValue, valueType);
            return this.value;
        }
        return objValue;
    }

    private Object getValueFromString(String localValue, Type valueType) throws InvalidParameterException {
        switch (valueType) {
            case STRING: {
                return localValue;
            }
            case INTEGER: {
                return Long.parseLong(localValue);
            }
            case NUMERIC: {
                return Double.parseDouble(localValue);
            }
            case DATE: {
                if (!StringUtils.isEmpty((String)this.getPattern())) {
                    SimpleDateFormat format = new SimpleDateFormat(this.getPattern());
                    try {
                        return format.parse(localValue);
                    }
                    catch (ParseException e) {
                        throw new InvalidParameterException("Unable to parse " + Type.DATE.getName() + " '" + localValue + "' with pattern " + this.getPattern(), e);
                    }
                }
                return new Date(Long.parseLong(localValue));
            }
            case STRING_ARRAY: {
                return this.parseToArray(localValue, Type.STRING, new String[0]);
            }
            case DATE_ARRAY: {
                return this.parseToArray(localValue, Type.DATE, new Date[0]);
            }
            case INTEGER_ARRAY: {
                return this.parseToArray(localValue, Type.INTEGER, new Long[0]);
            }
            case NUMERIC_ARRAY: {
                return this.parseToArray(localValue, Type.NUMERIC, new Double[0]);
            }
        }
        return localValue;
    }

    private <T> T[] parseToArray(String arrayAsString, Type elementType, T[] array) throws InvalidParameterException {
        CSVTokenizer tokenizer = new CSVTokenizer(arrayAsString, this.getSeparator());
        ArrayList<Object> result = new ArrayList<Object>();
        while (tokenizer.hasMoreTokens()) {
            result.add(this.getValueFromString(tokenizer.nextToken(), elementType));
        }
        return result.toArray(array);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.type == null ? null : this.type.getName();
    }

    public void setType(String type) {
        this.type = Type.parse(type);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    private String getValueAsString(Object value) {
        String separator = this.getSeparator();
        if (value == null) {
            if (this.getDefaultValue() != null) {
                return this.getDefaultValue().toString();
            }
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (this.type != null) {
            switch (this.type) {
                case STRING_ARRAY: {
                    if (value instanceof List) {
                        value = ((List)value).toArray();
                    }
                    if (!(value instanceof String[]) && value instanceof Object[]) {
                        Object[] oldVal = value;
                        String[] newVal = new String[oldVal.length];
                        for (int i = 0; i < oldVal.length; ++i) {
                            newVal[i] = "" + oldVal[i];
                        }
                        value = newVal;
                    }
                    String[] strArr = (String[])value;
                    int i = 0;
                    StringBuilder strBuild = new StringBuilder();
                    for (String s : strArr) {
                        if (i++ > 0) {
                            strBuild.append(separator);
                        }
                        strBuild.append('\"');
                        int lastWritten = 0;
                        int sepIdx = StringUtils.indexOf((String)s, (String)"'");
                        while (sepIdx >= 0) {
                            strBuild.append(s.substring(lastWritten, sepIdx));
                            strBuild.append('\"');
                            strBuild.append(separator);
                            strBuild.append('\"');
                            lastWritten = ++sepIdx;
                            sepIdx = StringUtils.indexOf((String)s, (String)"'", (int)sepIdx);
                        }
                        strBuild.append(StringUtils.substring((String)s, (int)lastWritten, (int)s.length()));
                        strBuild.append('\"');
                    }
                    return strBuild.toString();
                }
                case DATE: {
                    try {
                        Date dt = (Date)this.getValue();
                        return dt == null ? null : "" + dt.getTime();
                    }
                    catch (InvalidParameterException e) {
                        logger.error((Object)("Parameter of date type " + this.getName() + " does not yield date."), (Throwable)e);
                        break;
                    }
                }
                default: {
                    if (!(value instanceof Object[])) break;
                    Object[] arr = value;
                    int i = 0;
                    StringBuilder strBuild = new StringBuilder();
                    for (Object o : arr) {
                        if (i++ > 0) {
                            strBuild.append(separator);
                        }
                        if (o instanceof Date) {
                            strBuild.append(((Date)o).getTime());
                            continue;
                        }
                        strBuild.append(o);
                    }
                    return strBuild.toString();
                }
            }
        }
        return value.toString();
    }

    public String getStringValue() {
        return this.getValueAsString(this.value);
    }

    public void setStringValue(String stringValue) {
        this.value = stringValue;
    }

    public void setStringValue(String stringValue, Type type) {
        this.value = stringValue;
        this.type = type;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Access getAccess() {
        return this.access;
    }

    protected void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSeparator() {
        if (this.separator == null) {
            return DEFAULT_ARRAY_SEPERATOR;
        }
        return this.separator;
    }

    public String toString() {
        return this.getName() + "=" + this.getStringValue();
    }

    public static ParameterDataRow createParameterDataRowFromParameters(List<Parameter> parameters) throws InvalidParameterException {
        return Parameter.createParameterDataRowFromParameters(parameters.toArray(new Parameter[parameters.size()]));
    }

    public static ParameterDataRow createParameterDataRowFromParameters(Parameter[] parameters) throws InvalidParameterException {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                names.add(parameter.getName());
                values.add(parameter.getValue());
            }
        }
        ParameterDataRow parameterDataRow = new ParameterDataRow(names.toArray(new String[0]), values.toArray());
        return parameterDataRow;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof Parameter) {
            Parameter param = (Parameter)other;
            return StringUtils.equals((String)this.getName(), (String)param.getName()) && (this.getType() == null && param.getType() == null || this.getType().equals((Object)param.getType())) && StringUtils.equals((String)this.getStringValue(), (String)param.getStringValue());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getName() == null ? 0 : this.getName().hashCode();
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getStringValue() == null ? 0 : this.getStringValue().hashCode());
        return hashCode;
    }

    public void readObject(ObjectInputStream in) throws IOException {
        try {
            this.setName((String)in.readObject());
            this.setType((Type)((Object)in.readObject()));
            this.setStringValue((String)in.readObject(), this.getType());
            this.setSeparator((String)in.readObject());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error casting read object.", e);
        }
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getName());
        out.writeObject((Object)this.getType());
        out.writeObject(this.getStringValue());
        out.writeObject(this.getSeparator());
    }

    public void accept(DomVisitor xmlVisitor, Element daEle) {
        xmlVisitor.visit(this, daEle);
    }

    private String stringArrayToString(String[] stringArray, String separator) {
        String s;
        String START_CHAR = "[";
        String END_CHAR = "]";
        String SEPARATOR = ", ";
        if (stringArray != null && (s = Arrays.toString(stringArray)) != null && s.trim().length() > 0) {
            if (s.startsWith("[") && s.endsWith("]")) {
                s = s.substring(1, s.length() - 1);
            }
            if (separator != null) {
                s = s.replaceAll(", ", separator);
            }
            return s;
        }
        return null;
    }

    public static enum Type {
        STRING("String"),
        INTEGER("Integer"),
        NUMERIC("Numeric"),
        DATE("Date"),
        STRING_ARRAY("StringArray"),
        INTEGER_ARRAY("IntegerArray"),
        NUMERIC_ARRAY("NumericArray"),
        DATE_ARRAY("DateArray");

        private String name;

        private Type(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean isArrayType() {
            switch (this) {
                case STRING_ARRAY: 
                case INTEGER_ARRAY: 
                case NUMERIC_ARRAY: 
                case DATE_ARRAY: {
                    return true;
                }
            }
            return false;
        }

        public static Type parse(String typeString) {
            for (Type type : Type.values()) {
                if (!type.name.equals(typeString)) continue;
                return type;
            }
            return null;
        }

        public static Type inferTypeFromObject(Object obj) {
            if (obj != null) {
                if (Object[].class.isAssignableFrom(obj.getClass())) {
                    if (Double[].class.isAssignableFrom(obj.getClass())) {
                        return NUMERIC_ARRAY;
                    }
                    if (Long[].class.isAssignableFrom(obj.getClass())) {
                        return INTEGER_ARRAY;
                    }
                    if (Date[].class.isAssignableFrom(obj.getClass())) {
                        return DATE_ARRAY;
                    }
                    if (String[].class.isAssignableFrom(obj.getClass())) {
                        return STRING_ARRAY;
                    }
                } else {
                    if (Double.class.isAssignableFrom(obj.getClass())) {
                        return NUMERIC;
                    }
                    if (Long.class.isAssignableFrom(obj.getClass())) {
                        return INTEGER;
                    }
                    if (Date.class.isAssignableFrom(obj.getClass())) {
                        return DATE;
                    }
                    if (String.class.isAssignableFrom(obj.getClass())) {
                        return STRING;
                    }
                }
            }
            return null;
        }
    }

    public static enum Access {
        PRIVATE("private"),
        PUBLIC("public");

        private String name;

        private Access(String name) {
            this.name = name;
        }

        public static Access parse(String text) {
            for (Access type : Access.values()) {
                if (text == null || !type.name.equals(text.trim().toLowerCase())) continue;
                return type;
            }
            return PUBLIC;
        }

        public String toString() {
            return this.name;
        }
    }
}

