/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess.kettle;

import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLParameterLookupParser;
import pt.webdetails.cda.connections.sql.JdbcConnection;
import pt.webdetails.cda.connections.sql.JdbcConnectionInfo;
import pt.webdetails.cda.connections.sql.JndiConnection;
import pt.webdetails.cda.connections.sql.SqlConnection;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.SqlDataAccess;
import pt.webdetails.cda.dataaccess.kettle.DataAccessKettleAdapter;
import pt.webdetails.cda.dataaccess.kettle.KettleAdapterException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownConnectionException;

public class SQLKettleAdapter
implements DataAccessKettleAdapter {
    private SqlDataAccess dataAccess;
    private QueryOptions queryOptions;
    private DatabaseMeta databaseMeta;
    private String translatedQuery;
    private String[] parameterNames;
    private DataRow parameters;

    public SQLKettleAdapter(SqlDataAccess dataAccess, QueryOptions queryOptions) {
        this.dataAccess = dataAccess;
        this.queryOptions = queryOptions;
    }

    @Override
    public StepMeta getKettleStepMeta(String name) throws KettleAdapterException {
        try {
            TableInputMeta tableInputMeta = new TableInputMeta();
            tableInputMeta.setDatabaseMeta(this.getDatabaseMeta());
            this.prepareQuery();
            tableInputMeta.setSQL(this.translatedQuery);
            StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)tableInputMeta);
            stepMeta.setCopies(1);
            return stepMeta;
        }
        catch (Exception e) {
            throw new KettleAdapterException("Error initializing Kettle step for SQL data access type", e);
        }
    }

    private void prepareQuery() throws KettleAdapterException {
        if (this.translatedQuery == null) {
            try {
                this.parameters = Parameter.createParameterDataRowFromParameters(this.dataAccess.getFilledParameters(this.queryOptions));
                SQLParameterLookupParser parser = new SQLParameterLookupParser(true);
                this.translatedQuery = parser.translateAndLookup(this.dataAccess.getQuery(), this.parameters);
                this.parameterNames = parser.getFields();
            }
            catch (Exception e) {
                throw new KettleAdapterException("Unable to substitute data access parameters", e);
            }
        }
    }

    @Override
    public DataRow getParameters() throws KettleAdapterException {
        this.prepareQuery();
        return this.parameters;
    }

    @Override
    public String[] getParameterNames() throws KettleAdapterException {
        this.prepareQuery();
        return this.parameterNames;
    }

    protected DatabaseMeta getDatabaseMeta() throws KettleAdapterException {
        if (this.databaseMeta == null) {
            SqlConnection connection;
            try {
                connection = (SqlConnection)this.dataAccess.getCdaSettings().getConnection(this.dataAccess.getConnectionId());
            }
            catch (UnknownConnectionException e) {
                throw new KettleAdapterException(e);
            }
            if (connection instanceof JdbcConnection) {
                JdbcConnectionInfo connectionInfo = ((JdbcConnection)connection).getConnectionInfo();
                this.databaseMeta = new DatabaseMeta(connection.getId(), "GENERIC", "Native", null, null, null, connectionInfo.getUser(), connectionInfo.getPass());
                this.databaseMeta.getAttributes().put("CUSTOM_URL", connectionInfo.getUrl());
                this.databaseMeta.getAttributes().put("CUSTOM_DRIVER_CLASS", connectionInfo.getDriver());
            } else if (connection instanceof JndiConnection) {
                JndiConnection jndiConnection = (JndiConnection)connection;
                this.databaseMeta = new DatabaseMeta(connection.getId(), "GENERIC", "JNDI", null, jndiConnection.getConnectionInfo().getJndi(), null, null, null);
            } else {
                throw new KettleAdapterException("Unsupported connection type: " + connection.getClass().getName());
            }
        }
        return this.databaseMeta;
    }

    @Override
    public DatabaseMeta[] getDatabases() throws KettleAdapterException {
        return new DatabaseMeta[]{this.getDatabaseMeta()};
    }
}

