/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cda.CdaCoreService;
import pt.webdetails.cda.exporter.ExportOptions;
import pt.webdetails.cda.exporter.ExportedQueryResult;
import pt.webdetails.cda.utils.DoQueryParameters;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="/cda/api/utils")
public class RestEndpoint {
    private static String getEncoding() {
        return CharsetHelper.getEncoding();
    }

    @GET
    @Path(value="/doQuery")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void doQuery(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @DefaultValue(value="1") @QueryParam(value="outputIndexId") int outputIndexId, @DefaultValue(value="<blank>") @QueryParam(value="dataAccessId") String dataAccessId, @DefaultValue(value="false") @QueryParam(value="bypassCache") Boolean bypassCache, @DefaultValue(value="false") @QueryParam(value="paginateQuery") Boolean paginateQuery, @DefaultValue(value="0") @QueryParam(value="pageSize") int pageSize, @DefaultValue(value="0") @QueryParam(value="pageStart") int pageStart, @DefaultValue(value="false") @QueryParam(value="wrapItUp") Boolean wrapItUp, @QueryParam(value="sortBy") List<String> sortBy, @DefaultValue(value="<blank>") @QueryParam(value="jsonCallback") String jsonCallback, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        DoQueryParameters queryParams = new DoQueryParameters(path, solution, file);
        queryParams.setBypassCache(bypassCache);
        queryParams.setDataAccessId(dataAccessId);
        queryParams.setOutputIndexId(outputIndexId);
        queryParams.setOutputType(outputType);
        queryParams.setPageSize(pageSize);
        queryParams.setPageStart(pageStart);
        queryParams.setPaginateQuery(paginateQuery);
        queryParams.setSortBy(sortBy);
        queryParams.setWrapItUp(wrapItUp);
        queryParams.setJsonCallback(jsonCallback);
        CdaCoreService coreService = this.getCoreService();
        if (wrapItUp.booleanValue()) {
            this.writeOut((OutputStream)servletResponse.getOutputStream(), coreService.wrapQuery(queryParams));
        } else {
            coreService.doQuery(queryParams).writeResponse(servletResponse);
        }
    }

    @GET
    @Path(value="/unwrapQuery")
    @Consumes(value={"application/xml", "application/json"})
    public void unwrapQuery(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @QueryParam(value="uuid") String uuid, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        DoQueryParameters params = new DoQueryParameters(path, solution, file);
        coreService.unwrapQuery(params.getPath(), uuid).writeResponse(servletResponse);
    }

    @GET
    @Path(value="/listQueries")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void listQueries(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        DoQueryParameters params = new DoQueryParameters(path, solution, file);
        ExportedQueryResult result = coreService.listQueries(params.getPath(), this.getSimpleExportOptions(outputType));
        result.writeResponse(servletResponse);
    }

    @GET
    @Path(value="/listParameters")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    public void listParameters(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @DefaultValue(value="<blank>") @QueryParam(value="dataAccessId") String dataAccessId, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        DoQueryParameters params = new DoQueryParameters(path, solution, file);
        ExportedQueryResult result = coreService.listParameters(params.getPath(), dataAccessId, this.getSimpleExportOptions(outputType));
        result.writeResponse(servletResponse);
    }

    @GET
    @Path(value="/getCdaList")
    @Consumes(value={"application/xml", "application/json"})
    public void getCdaList(@QueryParam(value="path") String path, @QueryParam(value="solution") String solution, @QueryParam(value="file") String file, @DefaultValue(value="json") @QueryParam(value="outputType") String outputType, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        ExportedQueryResult result = coreService.getCdaList(this.getSimpleExportOptions(outputType));
        result.writeResponse(servletResponse);
    }

    private ExportOptions getSimpleExportOptions(final String outputType) {
        return new ExportOptions(){

            @Override
            public String getOutputType() {
                return outputType;
            }

            @Override
            public Map<String, String> getExtraSettings() {
                return Collections.emptyMap();
            }
        };
    }

    @GET
    @Path(value="/getCssResource")
    @Produces(value={"text/css"})
    @Consumes(value={"application/xml", "application/json"})
    public void getCssResource(@QueryParam(value="resource") String resource, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        this.getCssResource((OutputStream)servletResponse.getOutputStream(), resource);
    }

    @GET
    @Path(value="/getJsResource")
    @Produces(value={"text/javascript"})
    @Consumes(value={"application/xml", "application/json"})
    public void getJsResource(@QueryParam(value="resource") String resource, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        this.getJsResource((OutputStream)servletResponse.getOutputStream(), resource);
    }

    @GET
    @Path(value="/listDataAccessTypes")
    @Produces(value={"application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public String listDataAccessTypes(@DefaultValue(value="false") @QueryParam(value="refreshCache") Boolean refreshCache, @Context HttpServletResponse servletResponse, @Context HttpServletRequest servletRequest) throws Exception {
        CdaCoreService coreService = this.getCoreService();
        return coreService.listDataAccessTypes(refreshCache);
    }

    private CdaCoreService getCoreService() {
        return new CdaCoreService();
    }

    protected void writeOut(OutputStream out, String contents) throws IOException {
        IOUtils.write((String)contents, (OutputStream)out, (String)RestEndpoint.getEncoding());
        out.flush();
    }

    public String getResourceAsString(String path, HashMap<String, String> tokens) throws IOException {
        IReadAccess repository = this.getRepositoryAccess();
        String resourceContents = "";
        if (!repository.fileExists(path)) {
            return null;
        }
        resourceContents = Util.toString((InputStream)repository.getFileInputStream(path));
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                resourceContents = StringUtils.replace((String)resourceContents, (String)key, (String)tokens.get(key));
            }
        }
        return resourceContents;
    }

    public void getCssResource(OutputStream out, String resource) throws Exception {
        this.getResource(out, resource);
    }

    public void getJsResource(OutputStream out, String resource) throws Exception {
        this.getResource(out, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResource(OutputStream out, String resource) throws Exception {
        IReadAccess repo = this.getRepositoryAccess();
        if (repo.fileExists(resource)) {
            InputStream in = null;
            try {
                in = repo.getFileInputStream(resource);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private IReadAccess getRepositoryAccess() {
        return PluginEnvironment.env().getContentAccessFactory().getUserContentAccess("/");
    }
}

