/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.dataaccess.kettle.DataAccessKettleAdapter;
import pt.webdetails.cda.dataaccess.kettle.KettleAdapterException;
import pt.webdetails.cda.exporter.AbstractKettleExporter;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.StreamExporter;
import pt.webdetails.cda.utils.kettle.RowCountListener;
import pt.webdetails.robochef.DynamicTransConfig;
import pt.webdetails.robochef.DynamicTransMetaConfig;
import pt.webdetails.robochef.DynamicTransformation;
import pt.webdetails.robochef.RowProductionManager;
import pt.webdetails.robochef.TableModelInput;

public class DefaultStreamExporter
implements RowProductionManager,
StreamExporter {
    private static final Log logger = LogFactory.getLog(DefaultStreamExporter.class);
    private static long DEFAULT_ROW_PRODUCTION_TIMEOUT = 120L;
    private static TimeUnit DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private DataAccessKettleAdapter dataAccess;
    private AbstractKettleExporter exporter;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Collection<Callable<Boolean>> inputCallables = new ArrayList<Callable<Boolean>>();

    public DefaultStreamExporter(AbstractKettleExporter exporter, DataAccessKettleAdapter dataAccess) {
        this.exporter = exporter;
        this.dataAccess = dataAccess;
    }

    @Override
    public void export(OutputStream out) throws ExporterException {
        this.inputCallables.clear();
        try {
            DynamicTransConfig transConfig = new DynamicTransConfig();
            StepMeta dataAccessStepMeta = this.dataAccess.getKettleStepMeta("DataAccess");
            StepMeta injectorStepMeta = null;
            String[] parameterNames = this.dataAccess.getParameterNames();
            DataRow parameters = this.dataAccess.getParameters();
            if (parameterNames.length > 0) {
                injectorStepMeta = new StepMeta("Input", (StepMetaInterface)new InjectorMeta());
                injectorStepMeta.setCopies(1);
                transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, injectorStepMeta.getName(), injectorStepMeta.getXML());
                if (dataAccessStepMeta.getStepMetaInterface() instanceof TableInputMeta) {
                    ((TableInputMeta)dataAccessStepMeta.getStepMetaInterface()).setLookupFromStep(injectorStepMeta);
                }
            }
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, dataAccessStepMeta.getName(), dataAccessStepMeta.getXML());
            StepMeta exportStepMeta = this.exporter.getExportStepMeta("Export");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, exportStepMeta.getName(), exportStepMeta.getXML());
            if (parameterNames.length > 0) {
                transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, injectorStepMeta.getName(), dataAccessStepMeta.getName());
            }
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, dataAccessStepMeta.getName(), exportStepMeta.getName());
            if (parameterNames.length > 0) {
                LinkedList<String> columnNames = new LinkedList<String>();
                LinkedList columnClasses = new LinkedList();
                LinkedList<Object> values = new LinkedList<Object>();
                for (String parameterName : parameterNames) {
                    Object value = parameters.get(parameterName);
                    if (value instanceof Object[]) {
                        Object[] array = (Object[])value;
                        for (int c = 0; c < array.length; ++c) {
                            columnNames.add(parameterName + "_" + c);
                            columnClasses.add(array[c].getClass());
                            values.add(array[c]);
                        }
                        continue;
                    }
                    columnNames.add(parameterName);
                    columnClasses.add(value == null ? Object.class : value.getClass());
                    values.add(value);
                }
                TypedTableModel model = new TypedTableModel(columnNames.toArray(new String[columnNames.size()]), columnClasses.toArray(new Class[columnClasses.size()]));
                model.addRow(values.toArray());
                TableModelInput input = new TableModelInput();
                transConfig.addInput(injectorStepMeta.getName(), input);
                this.inputCallables.add(input.getCallableRowProducer((TableModel)model, true));
            }
            RowCountListener countListener = new RowCountListener();
            transConfig.addOutput(exportStepMeta.getName(), countListener);
            ExtendedDynamicTransMetaConfig transMetaConfig = new ExtendedDynamicTransMetaConfig(DynamicTransMetaConfig.Type.EMPTY, "Streaming Exporter", null, null, this.dataAccess.getDatabases());
            DynamicTransformation trans = new DynamicTransformation(transConfig, transMetaConfig);
            trans.executeCheckedSuccess(null, null, this);
            logger.info((Object)trans.getReadWriteThroughput());
            this.exporter.copyFileToOutputStream(out);
            logger.debug((Object)(countListener.getRowsWritten() + " rows written."));
        }
        catch (KettleAdapterException e) {
            throw new ExporterException("Data access to Kettle adapter exception during " + this.exporter.getType() + " query ", e);
        }
        catch (KettleException e) {
            throw new ExporterException("Kettle exception during " + this.exporter.getType() + " query ", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ExporterException("Unknown exception during " + this.exporter.getType() + " query ", e);
        }
    }

    @Override
    public void startRowProduction() {
        String timeoutStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeout");
        long timeout = StringUtil.isEmpty((String)timeoutStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT : Long.parseLong(timeoutStr);
        String unitStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeoutTimeUnit");
        TimeUnit unit = StringUtil.isEmpty((String)unitStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT : TimeUnit.valueOf(unitStr);
        this.startRowProduction(timeout, unit);
    }

    @Override
    public void startRowProduction(long timeout, TimeUnit unit) {
        try {
            List<Future<Boolean>> results = this.executorService.invokeAll(this.inputCallables, timeout, unit);
            for (Future<Boolean> result : results) {
                result.get();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public String getMimeType() {
        return this.exporter.getMimeType();
    }

    @Override
    public String getAttachmentName() {
        return this.exporter.getAttachmentName();
    }

    public static class ExtendedDynamicTransMetaConfig
    extends DynamicTransMetaConfig {
        private DatabaseMeta[] databases;

        public ExtendedDynamicTransMetaConfig(DynamicTransMetaConfig.Type type, String name, String configDataSource, DynamicTransMetaConfig.RepositoryConfig repoConfig, DatabaseMeta[] databases) throws KettleException {
            super(type, name, configDataSource, repoConfig);
            this.databases = databases;
        }

        @Override
        protected TransMeta getTransMeta(VariableSpace variableSpace) throws KettleException {
            TransMeta transMeta = super.getTransMeta(variableSpace);
            if (this.databases != null) {
                for (DatabaseMeta database : this.databases) {
                    transMeta.addOrReplaceDatabase(database);
                }
            }
            return transMeta;
        }
    }
}

