/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cda.exporter.Exporter;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.utils.MimeTypes;

public abstract class ExportedQueryResult {
    private Exporter exporter;

    public ExportedQueryResult(Exporter exporter) {
        assert (exporter != null);
        this.exporter = exporter;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public void writeHeaders(HttpServletResponse response) throws IOException {
        ExportedQueryResult.setResponseHeaders(response, this.exporter.getMimeType(), this.exporter.getAttachmentName());
    }

    public void writeResponse(HttpServletResponse response) throws ExporterException, IOException {
        ExportedQueryResult.setResponseHeaders(response, this.exporter.getMimeType(), this.exporter.getAttachmentName());
        ServletOutputStream out = response.getOutputStream();
        this.writeOut((OutputStream)out);
    }

    public abstract void writeOut(OutputStream var1) throws ExporterException;

    public String asString() throws ExporterException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeOut(out);
        return Util.toString((byte[])out.toByteArray());
    }

    private static void setResponseHeaders(HttpServletResponse response, String mimeType, String attachmentName) {
        if (StringUtils.isEmpty((String)mimeType) && !StringUtils.isEmpty((String)attachmentName)) {
            mimeType = MimeTypes.getMimeType((String)attachmentName);
        }
        response.setContentType(mimeType);
        if (attachmentName != null) {
            response.setHeader("content-disposition", "attachment; filename=" + attachmentName);
        }
    }
}

